/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.jena.graph.Node;
import org.apache.jena.shex.expressions.NodeConstraintComponent;
import org.apache.jena.shex.expressions.NodeConstraintVisitor;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.ValidationContext;
import org.apache.jena.sparql.expr.RegexEngine;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;

public class StrRegexConstraint
extends NodeConstraintComponent {
    private final Pattern pattern;
    private final String patternString;
    private final String flagsStr;

    public StrRegexConstraint(String pattern, String flagsStr) {
        this.flagsStr = flagsStr;
        int flags = RegexEngine.makeMask((String)flagsStr);
        this.patternString = flagsStr != null && flagsStr.contains("q") ? Pattern.quote(pattern) : pattern;
        this.pattern = Pattern.compile(pattern, flags);
    }

    public String getPattern() {
        return this.patternString;
    }

    public String getFlagsStr() {
        return this.flagsStr;
    }

    @Override
    public ReportItem nodeSatisfies(ValidationContext vCxt, Node n) {
        if (n.isBlank()) {
            String msg = this.toString() + ": Blank node: " + ShexLib.displayStr(n);
            return new ReportItem(msg, n);
        }
        String str = NodeFunctions.str((Node)n);
        boolean b = this.pattern.matcher(str).find();
        if (b) {
            return null;
        }
        String msg = this.toString() + ": Does not match: '" + str + "'";
        return new ReportItem(msg, n);
    }

    @Override
    public void visit(NodeConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.flagsStr != null && !this.flagsStr.isEmpty()) {
            return "Pattern[" + this.patternString + "(" + this.flagsStr + ")]";
        }
        return "Pattern[" + this.patternString + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrRegexConstraint)) {
            return false;
        }
        StrRegexConstraint other = (StrRegexConstraint)obj;
        return Objects.equals(this.patternString, other.patternString);
    }
}

