/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.MaxCardinalityRestriction;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.impl.RestrictionImpl;

public class MaxCardinalityRestrictionImpl
extends RestrictionImpl
implements MaxCardinalityRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new MaxCardinalityRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + String.valueOf(n) + " to MaxCardinalityRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, MaxCardinalityRestriction.class);
        }
    };

    public MaxCardinalityRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setMaxCardinality(int cardinality) {
        this.setPropertyValue(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getMaxCardinality() {
        return this.objectAsInt(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY");
    }

    @Override
    public boolean hasMaxCardinality(int cardinality) {
        return this.hasPropertyValue(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeMaxCardinality(int cardinality) {
        this.removePropertyValue(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }
}

