/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetMem;
import org.apache.jena.sparql.exec.RowSetRewindable;

public class RowSetStream
implements RowSet {
    private Iterator<Binding> iterator;
    private List<Var> resultVars;
    private int rowNumber;

    public static RowSet create(List<Var> vars, Iterator<Binding> iterator) {
        return new RowSetStream(vars, iterator);
    }

    protected RowSetStream(List<Var> resultVars, Iterator<Binding> bindings) {
        this.iterator = bindings;
        this.resultVars = new ArrayList<Var>(resultVars);
        this.rowNumber = 0;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Binding next() {
        ++this.rowNumber;
        return this.iterator.next();
    }

    @Override
    public List<Var> getResultVars() {
        return this.resultVars;
    }

    @Override
    public RowSetRewindable rewindable() {
        return RowSetMem.create(this);
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public void close() {
        Iter.close(this.iterator);
    }

    public void forEachRemaining(Consumer<? super Binding> action) {
        this.iterator.forEachRemaining((? super E b) -> {
            ++this.rowNumber;
            action.accept((Binding)b);
        });
    }
}

