/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction.library;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.pfunction.PFuncSimple;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.util.IterLib;

public class str
extends PFuncSimple {
    @Override
    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
    }

    @Override
    public QueryIterator execEvaluated(Binding binding, Node subject, Node predicate, Node object, ExecutionContext execCxt) {
        if (subject.isURI() || subject.isBlank()) {
            return IterLib.noResults(execCxt);
        }
        if (Var.isVar(subject) && Var.isVar(object)) {
            throw new QueryExecException("str: Both subject and object are unbound variables");
        }
        if (Var.isVar(object)) {
            throw new QueryExecException("str: Object is an unbound variables");
        }
        if (object.isBlank()) {
            throw new QueryExecException("str: object is a blank node");
        }
        Node strValue = NodeFactory.createLiteralString((String)NodeFunctions.str(object));
        if (Var.isVar(subject)) {
            return IterLib.oneResult(binding, Var.alloc(subject), strValue, execCxt);
        }
        if (subject.equals((Object)strValue)) {
            return IterLib.result(binding, execCxt);
        }
        return IterLib.noResults(execCxt);
    }
}

