/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs.engine;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.engine.Mappers;
import org.apache.jena.rdfs.engine.MatchRDFS;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.util.iterator.ExtendedIterator;

public class InfFindTriple
extends MatchRDFS<Node, Triple> {
    private final Graph graph;

    public InfFindTriple(ConfigRDFS<Node> setup, Graph graph) {
        super(setup, Mappers.mapperTriple());
        this.graph = graph;
    }

    @Override
    public Stream<Triple> sourceFind(Node s, Node p, Node o) {
        ExtendedIterator iter = this.graph.find(s, p, o);
        Stream stream = Iter.asStream((Iterator)iter);
        return stream;
    }

    @Override
    protected boolean sourceContains(Node s, Node p, Node o) {
        return this.graph.contains(s, p, o);
    }

    @Override
    protected Triple dstCreate(Node s, Node p, Node o) {
        return Triple.create((Node)s, (Node)p, (Node)o);
    }
}

