/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAntiJoin;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementSemiJoin;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnfold;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.sparql.util.VarUtils;

public class PatternVars {
    public static Collection<Var> vars(Element element) {
        return PatternVars.vars(new LinkedHashSet<Var>(), element);
    }

    public static Collection<Var> vars(Collection<Var> s, Element element) {
        PatternVarsVisitor v = new PatternVarsVisitor(s);
        PatternVars.vars(element, v);
        return s;
    }

    public static void vars(Element element, PatternVarsVisitor visitor) {
        WalkerSkipNonBinding walker = new WalkerSkipNonBinding(visitor);
        ElementWalker.walk$(element, walker);
    }

    private static class PatternVarsVisitor
    extends ElementVisitorBase {
        public Collection<Var> acc;

        PatternVarsVisitor(Collection<Var> s) {
            this.acc = s;
        }

        @Override
        public void visit(ElementTriplesBlock el) {
            Iterator<Triple> iter = el.patternElts();
            while (iter.hasNext()) {
                Triple t = iter.next();
                VarUtils.addVarsFromTriple(this.acc, t);
            }
        }

        @Override
        public void visit(ElementPathBlock el) {
            Iterator<TriplePath> iter = el.patternElts();
            while (iter.hasNext()) {
                TriplePath tp = iter.next();
                if (tp.isTriple()) {
                    VarUtils.addVarsFromTriple(this.acc, tp.asTriple());
                    continue;
                }
                VarUtils.addVarsFromTriplePath(this.acc, tp);
            }
        }

        @Override
        public void visit(ElementExists el) {
        }

        @Override
        public void visit(ElementNotExists el) {
        }

        @Override
        public void visit(ElementMinus el) {
        }

        @Override
        public void visit(ElementSemiJoin el) {
        }

        @Override
        public void visit(ElementAntiJoin el) {
        }

        @Override
        public void visit(ElementFilter el) {
        }

        @Override
        public void visit(ElementNamedGraph el) {
            VarUtils.addVar(this.acc, el.getGraphNameNode());
        }

        @Override
        public void visit(ElementSubQuery el) {
            VarExprList x = el.getQuery().getProject();
            this.acc.addAll(x.getVars());
        }

        @Override
        public void visit(ElementAssign el) {
            this.acc.add(el.getVar());
        }

        @Override
        public void visit(ElementBind el) {
            this.acc.add(el.getVar());
        }

        @Override
        public void visit(ElementUnfold el) {
            this.acc.add(el.getVar1());
            if (el.getVar2() != null) {
                this.acc.add(el.getVar2());
            }
        }

        @Override
        public void visit(ElementData el) {
            this.acc.addAll(el.getVars());
        }
    }

    private static class WalkerSkipNonBinding
    extends ElementWalker.EltWalker {
        protected WalkerSkipNonBinding(ElementVisitor visitor) {
            super(visitor, null, null);
        }

        @Override
        public void visit(ElementMinus el) {
            this.proc.visit(el);
        }

        @Override
        public void visit(ElementSemiJoin el) {
            this.proc.visit(el);
        }

        @Override
        public void visit(ElementAntiJoin el) {
            this.proc.visit(el);
        }
    }
}

