/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.expansion;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.uri.UriResolver;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.jsonld.uri.UriValidationPolicy;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class UriExpansion {
    private static final Logger LOGGER = Logger.getLogger(UriExpansion.class.getName());
    private final ActiveContext activeContext;
    private boolean documentRelative;
    private boolean vocab;
    private UriValidationPolicy uriValidation;
    private JsonObject localContext;
    private Map<String, Boolean> defined;

    private UriExpansion(ActiveContext activeContext) {
        this.activeContext = activeContext;
        this.documentRelative = false;
        this.vocab = false;
        this.localContext = null;
        this.defined = null;
        this.uriValidation = JsonLdOptions.DEFAULT_URI_VALIDATION;
    }

    public static final UriExpansion with(ActiveContext activeContext) {
        return new UriExpansion(activeContext);
    }

    public UriExpansion documentRelative(boolean value) {
        this.documentRelative = value;
        return this;
    }

    public UriExpansion vocab(boolean value) {
        this.vocab = value;
        return this;
    }

    public UriExpansion localContext(JsonObject value) {
        this.localContext = value;
        return this;
    }

    public UriExpansion defined(Map<String, Boolean> value) {
        this.defined = value;
        return this;
    }

    public String expand(String value) throws JsonLdError {
        if (value == null || Keywords.contains(value)) {
            return value;
        }
        if (Keywords.matchForm(value)) {
            LOGGER.log(Level.WARNING, "Value [{0}] of keyword form [@1*ALPHA] is not allowed.", value);
            return null;
        }
        this.initLocalContext(value);
        Optional<TermDefinition> definition = this.activeContext.getTerm(value).filter(term -> this.vocab || Keywords.contains(term.getUriMapping()));
        if (definition.isPresent()) {
            return definition.get().getUriMapping();
        }
        String result = value;
        int splitIndex = result.indexOf(58, 1);
        if (splitIndex != -1) {
            if (splitIndex == 1 && result.charAt(0) == '_' || splitIndex + 2 < result.length() && result.charAt(splitIndex + 1) == '/' && result.charAt(splitIndex + 2) == '/') {
                return result;
            }
            if (BlankNode.hasPrefix(result = this.initPropertyContext(result.substring(0, splitIndex), splitIndex + 1 < result.length() ? result.substring(splitIndex + 1) : "", result)) || UriUtils.isAbsoluteUri(result, this.uriValidation)) {
                return result;
            }
        }
        return this.expandResult(result);
    }

    private void initLocalContext(String value) throws JsonLdError {
        String entryValueString;
        JsonValue entryValue;
        if (this.localContext != null && this.localContext.containsKey((Object)value) && JsonUtils.isString(entryValue = (JsonValue)this.localContext.get((Object)value)) && (!this.defined.containsKey(entryValueString = ((JsonString)entryValue).getString()) || Boolean.FALSE.equals(this.defined.get(entryValueString)))) {
            this.activeContext.newTerm(this.localContext, this.defined).create(value);
        }
    }

    private String initPropertyContext(String prefix, String suffix, String result) throws JsonLdError {
        if (this.localContext != null && this.localContext.containsKey((Object)prefix) && !Boolean.TRUE.equals(this.defined.get(prefix))) {
            this.activeContext.newTerm(this.localContext, this.defined).create(prefix);
        }
        return this.activeContext.getTerm(prefix).filter(TermDefinition::isPrefix).map(TermDefinition::getUriMapping).map(uriMapping -> uriMapping.concat(suffix)).orElse(result);
    }

    private String expandResult(String result) {
        if (this.vocab && this.activeContext.getVocabularyMapping() != null) {
            return this.activeContext.getVocabularyMapping().concat(result);
        }
        if (this.documentRelative) {
            return UriResolver.resolve(this.activeContext.getBaseUri(), result);
        }
        return result;
    }

    @Deprecated
    public UriExpansion uriValidation(boolean enabled) {
        return this.uriValidation(enabled ? UriValidationPolicy.Full : UriValidationPolicy.SchemeOnly);
    }

    public UriExpansion uriValidation(UriValidationPolicy uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }
}

