/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.bulkloader;

import java.util.concurrent.Semaphore;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.tdb1.store.bulkloader.BuilderSecondaryIndexes;
import org.apache.jena.tdb1.store.bulkloader.LoadMonitor;
import org.apache.jena.tdb1.store.bulkloader.LoaderNodeTupleTable;
import org.apache.jena.tdb1.store.tupletable.TupleIndex;

public class BuilderSecondaryIndexesParallel
implements BuilderSecondaryIndexes {
    private LoadMonitor monitor;

    public BuilderSecondaryIndexesParallel(LoadMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void createSecondaryIndexes(TupleIndex primaryIndex, TupleIndex[] secondaryIndexes) {
        this.monitor.print("** Parallel index building", new Object[0]);
        Timer timer = new Timer();
        timer.startTimer();
        int semaCount = 0;
        Semaphore sema = new Semaphore(0);
        for (TupleIndex index : secondaryIndexes) {
            if (index == null) continue;
            Runnable builder = this.setup(sema, primaryIndex, index, index.getMappingStr());
            new Thread(builder).start();
            ++semaCount;
        }
        try {
            sema.acquire(semaCount);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        long time = timer.readTimer();
        timer.endTimer();
        this.monitor.print("Time for parallel indexing: %.2fs\n", (double)time / 1000.0);
    }

    private Runnable setup(final Semaphore sema, final TupleIndex srcIndex, final TupleIndex destIndex, final String label) {
        Runnable builder = new Runnable(){

            @Override
            public void run() {
                LoaderNodeTupleTable.copyIndex(srcIndex.all(), new TupleIndex[]{destIndex}, label, BuilderSecondaryIndexesParallel.this.monitor);
                sema.release();
            }
        };
        return builder;
    }
}

