/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.vocabulary.RDF;

public class LiteralLabelFactory {
    private static final RDFDatatype dtLangString = NodeFactory.getType(RDF.Nodes.langString.getURI());
    private static final RDFDatatype dtDirLangString = NodeFactory.getType(RDF.Nodes.dirLangString.getURI());

    private static RDFDatatype fixDatatype(RDFDatatype dtype, String lang, TextDirection textDir) {
        if (dtype != null) {
            return dtype;
        }
        if (Lib.isEmpty(lang) && textDir == null) {
            return XSDDatatype.XSDstring;
        }
        if (textDir == null) {
            return dtLangString;
        }
        return dtDirLangString;
    }

    public static LiteralLabel createString(String lex) {
        return new LiteralLabel(lex, "", Node.noTextDirection, XSDDatatype.XSDstring);
    }

    public static LiteralLabel createLang(String lex, String lang) {
        RDFDatatype dt = LiteralLabelFactory.fixDatatype(null, lang, Node.noTextDirection);
        return new LiteralLabel(lex, lang, Node.noTextDirection, dt);
    }

    public static LiteralLabel createDirLang(String lex, String lang, TextDirection textDir) {
        RDFDatatype dt = LiteralLabelFactory.fixDatatype(null, lang, textDir);
        return new LiteralLabel(lex, lang, textDir, dt);
    }

    public static LiteralLabel create(String lex, RDFDatatype dtype) {
        return new LiteralLabel(lex, dtype);
    }

    public static LiteralLabel createLiteralLabel(String lex, String lang, TextDirection textDir, RDFDatatype dtype) {
        dtype = LiteralLabelFactory.fixDatatype(dtype, lang, textDir);
        return new LiteralLabel(lex, lang, textDir, dtype);
    }

    public static LiteralLabel createByValue(Object value) throws DatatypeFormatException {
        return new LiteralLabel(value);
    }

    public static LiteralLabel createByValue(Object value, RDFDatatype dtype) throws DatatypeFormatException {
        dtype = LiteralLabelFactory.fixDatatype(dtype, null, null);
        return new LiteralLabel(value, dtype);
    }

    public static LiteralLabel createIncludingValue(String lex, Object value, RDFDatatype dtype) {
        return new LiteralLabel(lex, value, dtype);
    }

    public static LiteralLabel createTypedLiteral(Object value) {
        return new LiteralLabel(value);
    }
}

