/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.eval;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.atlas.lib.StreamOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.ShexException;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.eval.ShapeEvalCardinality;
import org.apache.jena.shex.eval.ShapeEvalEachOf;
import org.apache.jena.shex.eval.ShapeEvalOneOf;
import org.apache.jena.shex.eval.ShapeEvalTripleConstraint;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.TripleConstraint;
import org.apache.jena.shex.expressions.TripleExprCardinality;
import org.apache.jena.shex.expressions.TripleExprEachOf;
import org.apache.jena.shex.expressions.TripleExprNone;
import org.apache.jena.shex.expressions.TripleExprOneOf;
import org.apache.jena.shex.expressions.TripleExprRef;
import org.apache.jena.shex.expressions.TripleExprVisitor;
import org.apache.jena.shex.expressions.TripleExpression;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ValidationContext;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ShapeEval {
    static boolean DEBUG;
    static boolean DEBUG_eachOf;
    static boolean DEBUG_cardinalityOf;

    public static void debug(boolean debug2) {
        DEBUG = debug2;
        DEBUG_eachOf = debug2;
        DEBUG_cardinalityOf = debug2;
    }

    public static boolean matchesShapeExpr(ValidationContext vCxt, ShapeExpression shapeExpr, Node node) {
        return shapeExpr.satisfies(vCxt, node);
    }

    public static boolean matchesTripleExpr(ValidationContext vCxt, TripleExpression tripleExpr, Node node, Set<Node> extras, boolean closed) {
        Set<Triple> non_matchables;
        HashSet<Triple> arcsOut = new HashSet<Triple>();
        ShapeEval.arcsOut(arcsOut, vCxt.getData(), node);
        Set<Node> predicates = ShapeEval.findPredicates(vCxt, tripleExpr);
        Set<Triple> matchables = StreamOps.toSet(arcsOut.stream().filter(t -> predicates.contains(t.getPredicate())));
        boolean b = ShapeEval.matches(vCxt, matchables, node, tripleExpr, extras);
        if (!b) {
            return false;
        }
        return !closed || (non_matchables = StreamOps.toSet(arcsOut.stream().filter(t -> !matchables.contains(t)))).isEmpty();
    }

    static boolean matches(ValidationContext vCxt, Set<Triple> matchables, Node node, TripleExpression tripleExpr, Set<Node> extras) {
        return ShapeEval.matchesExpr(vCxt, matchables, node, tripleExpr, extras);
    }

    private static boolean matchesExpr(ValidationContext vCxt, Set<Triple> T, Node node, TripleExpression tripleExpr, Set<Node> extras) {
        if (tripleExpr instanceof TripleExprEachOf) {
            TripleExprEachOf eachOf = (TripleExprEachOf)tripleExpr;
            return ShapeEvalEachOf.matchesEachOf(vCxt, T, node, eachOf, extras);
        }
        if (tripleExpr instanceof TripleExprOneOf) {
            TripleExprOneOf oneOf = (TripleExprOneOf)tripleExpr;
            return ShapeEvalOneOf.matchesOneOf(vCxt, T, node, oneOf, extras);
        }
        if (tripleExpr instanceof TripleExprRef) {
            TripleExprRef ref = (TripleExprRef)tripleExpr;
            return ShapeEval.matchesTripleExprRef(vCxt, T, node, ref, extras);
        }
        if (tripleExpr instanceof TripleExprCardinality) {
            TripleExprCardinality card = (TripleExprCardinality)tripleExpr;
            return ShapeEvalCardinality.matchesCardinality(vCxt, T, node, card, extras);
        }
        if (tripleExpr instanceof TripleConstraint) {
            TripleConstraint constraint = (TripleConstraint)tripleExpr;
            return ShapeEvalTripleConstraint.matchesCardinalityTC(vCxt, T, node, constraint, extras);
        }
        if (tripleExpr instanceof TripleExprNone) {
            return true;
        }
        throw new NotImplemented(tripleExpr.getClass().getSimpleName());
    }

    private static boolean matchesTripleExprRef(ValidationContext vCxt, Set<Triple> matchables, Node node, TripleExprRef ref, Set<Node> extras) {
        TripleExpression tripleExpr;
        Node label = ref.ref();
        if (label == null) {
            // empty if block
        }
        if ((tripleExpr = vCxt.getTripleExpression(label)) == null) {
            ReportItem rItem = new ReportItem("Failed to get triple expression from reference", label);
            vCxt.reportEntry(rItem);
        }
        return ShapeEval.matches(vCxt, matchables, node, tripleExpr, extras);
    }

    private static TripleExprVisitor walk(final ShexSchema shapes, final TripleExprVisitor step) {
        return new TripleExprVisitor(){

            @Override
            public void visit(TripleExprCardinality expr) {
                expr.visit(step);
                expr.target().visit(this);
            }

            @Override
            public void visit(TripleExprEachOf expr) {
                expr.visit(step);
                expr.expressions().forEach(ex -> ex.visit(this));
            }

            @Override
            public void visit(TripleExprOneOf expr) {
                expr.visit(step);
                expr.expressions().forEach(ex -> ex.visit(this));
            }

            @Override
            public void visit(TripleExprNone expr) {
                expr.visit(step);
            }

            @Override
            public void visit(TripleExprRef expr) {
                expr.visit(step);
                if (expr.ref() == null) {
                    throw new ShexException("Failed to dereference : " + String.valueOf(expr.ref()));
                }
                shapes.getTripleExpression(expr.ref()).visit(this);
            }

            @Override
            public void visit(TripleConstraint expr) {
                expr.visit(step);
            }
        };
    }

    static Set<TripleConstraint> findTripleConstraint(ValidationContext vCxt, TripleExpression tripleExpr) {
        HashSet<TripleConstraint> constraints = new HashSet<TripleConstraint>();
        tripleExpr.visit(ShapeEval.accumulator(vCxt.getShapes(), constraints, Function.identity()));
        return constraints;
    }

    static Set<Node> findPredicates(ValidationContext vCxt, TripleExpression tripleExpr) {
        HashSet<Node> predicates = new HashSet<Node>();
        tripleExpr.visit(ShapeEval.accumulator(vCxt.getShapes(), predicates, TripleConstraint::getPredicate));
        return predicates;
    }

    private static <X> TripleExprVisitor accumulator(ShexSchema shapes, final Set<X> acc, final Function<TripleConstraint, X> mapper) {
        TripleExprVisitor step = new TripleExprVisitor(){

            @Override
            public void visit(TripleConstraint tripleConstraint) {
                acc.add(mapper.apply(tripleConstraint));
            }
        };
        return ShapeEval.walk(shapes, step);
    }

    private static void arcsOut(Set<Triple> neigh, Graph graph, Node node) {
        ExtendedIterator<Triple> x = G.find(graph, node, null, null);
        x.forEach(neigh::add);
    }

    private static void arcsIn(Set<Triple> neigh, Graph graph, Node node) {
        ExtendedIterator<Triple> x = G.find(graph, null, null, node);
        x.forEach(neigh::add);
    }

    static {
        DEBUG_eachOf = DEBUG = false;
        DEBUG_cardinalityOf = DEBUG;
    }
}

