/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.transaction;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.base.block.Block;
import org.apache.jena.tdb1.base.block.BlockException;
import org.apache.jena.tdb1.base.block.BlockMgr;
import org.apache.jena.tdb1.base.file.BufferAllocator;
import org.apache.jena.tdb1.base.file.BufferAllocatorDirect;
import org.apache.jena.tdb1.base.file.BufferAllocatorMapped;
import org.apache.jena.tdb1.base.file.BufferAllocatorMem;
import org.apache.jena.tdb1.sys.FileRef;
import org.apache.jena.tdb1.transaction.JournalEntryType;
import org.apache.jena.tdb1.transaction.Transaction;
import org.apache.jena.tdb1.transaction.TransactionLifecycle;
import org.apache.jena.tdb1.transaction.TxnState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMgrJournal
implements BlockMgr,
TransactionLifecycle {
    private static Logger log = LoggerFactory.getLogger(BlockMgrJournal.class);
    private BlockMgr blockMgr;
    private Transaction transaction;
    private FileRef fileRef;
    private final BufferAllocator writeBlockBufferAllocator;
    private final Set<Long> readBlocks = new HashSet<Long>();
    private final Set<Long> iteratorBlocks = new HashSet<Long>();
    private final Map<Long, Block> writeBlocks = new HashMap<Long, Block>();
    private final Map<Long, Block> freedBlocks = new HashMap<Long, Block>();
    private boolean closed = false;
    private boolean active = false;

    public BlockMgrJournal(Transaction txn, FileRef fileRef, BlockMgr underlyingBlockMgr) {
        String mode;
        Context context2 = txn.getBaseDataset().getContext();
        String string = mode = null != context2 ? context2.get(TDB1.transactionJournalWriteBlockMode, "") : "";
        this.writeBlockBufferAllocator = "direct".equalsIgnoreCase(mode) ? new BufferAllocatorDirect() : ("mapped".equalsIgnoreCase(mode) ? new BufferAllocatorMapped(8192) : new BufferAllocatorMem());
        this.reset(txn, fileRef, underlyingBlockMgr);
        if (txn.getTxnMode() == ReadWrite.READ && underlyingBlockMgr instanceof BlockMgrJournal) {
            log.error("Two level BlockMgrJournal");
        }
    }

    @Override
    public void begin(Transaction txn) {
        this.reset(txn, this.fileRef, this.blockMgr);
    }

    @Override
    public void commitPrepare(Transaction txn) {
        this.checkActive();
        for (Block blk : this.writeBlocks.values()) {
            this.writeJournalEntry(blk);
        }
        this.active = false;
    }

    @Override
    public void committed(Transaction txn) {
    }

    @Override
    public void enactCommitted(Transaction txn) {
    }

    @Override
    public void clearupCommitted(Transaction txn) {
        this.clear(txn);
    }

    @Override
    public void abort(Transaction txn) {
        this.active = false;
        this.clear(txn);
    }

    private void reset(Transaction txn, FileRef fileRef, BlockMgr underlyingBlockMgr) {
        this.fileRef = fileRef;
        this.blockMgr = underlyingBlockMgr;
        this.active = true;
        this.clear(txn);
    }

    private void clear(Transaction txn) {
        this.transaction = txn;
        this.readBlocks.clear();
        this.iteratorBlocks.clear();
        this.writeBlocks.clear();
        this.freedBlocks.clear();
        this.writeBlockBufferAllocator.clear();
    }

    @Override
    public Block allocate(int blockSize) {
        this.checkIfClosed();
        Block block = this.blockMgr.allocate(blockSize);
        if (this.active) {
            block = this.replicate(block);
            this.writeBlocks.put(block.getId(), block);
        }
        return block;
    }

    @Override
    public Block getRead(long id) {
        this.checkIfClosed();
        Block block = this.localBlock(id);
        if (block != null) {
            return block;
        }
        block = this.blockMgr.getRead(id);
        if (this.active) {
            this.readBlocks.add(block.getId());
        }
        return block;
    }

    @Override
    public Block getReadIterator(long id) {
        this.checkIfClosed();
        Block block = this.localBlock(id);
        if (block == null) {
            block = this.blockMgr.getReadIterator(id);
        }
        if (block == null) {
            throw new BlockException("No such block: " + this.getLabel() + " " + id);
        }
        if (this.active) {
            this.iteratorBlocks.add(block.getId());
        }
        return block;
    }

    @Override
    public Block getWrite(long id) {
        this.checkActive();
        this.checkIfClosed();
        Block block = this.localBlock(id);
        if (block != null) {
            return block;
        }
        block = this.blockMgr.getRead(id);
        block = this._promote(block);
        return block;
    }

    private Block localBlock(long id) {
        this.checkIfClosed();
        return this.writeBlocks.get(id);
    }

    @Override
    public Block promote(Block block) {
        this.checkIfClosed();
        if (this.writeBlocks.containsKey(block.getId())) {
            return block;
        }
        return this._promote(block);
    }

    private Block _promote(Block block) {
        this.checkActive();
        block = this.replicate(block);
        this.writeBlocks.put(block.getId(), block);
        return block;
    }

    @Override
    public void release(Block block) {
        this.checkIfClosed();
        Long id = block.getId();
        if (!this.writeBlocks.containsKey(id)) {
            this.blockMgr.release(block);
        }
    }

    @Override
    public void write(Block block) {
        this.checkIfClosed();
        if (!block.isModified()) {
            Log.warn(this, "Page for block " + String.valueOf(this.fileRef) + "/" + block.getId() + " not modified");
        }
        if (!this.writeBlocks.containsKey(block.getId())) {
            Log.warn(this, "Block not recognized: " + block.getId());
            this.writeBlocks.put(block.getId(), block);
        }
    }

    @Override
    public void overwrite(Block block) {
        this.blockMgr.overwrite(block);
    }

    @Override
    public void free(Block block) {
        this.checkIfClosed();
        this.freedBlocks.put(block.getId(), block);
    }

    @Override
    public boolean isEmpty() {
        this.checkIfClosed();
        return this.writeBlocks.isEmpty() && this.blockMgr.isEmpty();
    }

    @Override
    public boolean valid(int id) {
        this.checkIfClosed();
        if (this.writeBlocks.containsKey(id)) {
            return true;
        }
        return this.blockMgr.valid(id);
    }

    @Override
    public void close() {
        this.writeBlockBufferAllocator.close();
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private void checkIfClosed() {
        if (this.closed) {
            Log.error(this, "Already closed: " + this.transaction.getTxnId());
        }
    }

    private void checkActive() {
        TxnState state;
        if (!this.active) {
            Log.error(this, "Not active: " + this.transaction.getTxnId());
        }
        if ((state = this.transaction.getState()) != TxnState.ACTIVE && state != TxnState.PREPARING) {
            Log.error(this, "**** Not active: " + this.transaction.getTxnId());
        }
    }

    @Override
    public void sync() {
        this.checkIfClosed();
    }

    @Override
    public void syncForce() {
        this.blockMgr.syncForce();
    }

    @Override
    public void beginUpdate() {
        this.checkIfClosed();
        this.blockMgr.beginRead();
    }

    @Override
    public void endUpdate() {
        this.checkIfClosed();
        this.blockMgr.endRead();
    }

    private void writeJournalEntry(Block blk) {
        blk.getByteBuffer().rewind();
        this.transaction.getJournal().write(JournalEntryType.Block, this.fileRef, blk);
    }

    private void logState() {
        Log.info(this, "state: " + this.getLabel());
        Log.info(this, "  readBlocks:      " + String.valueOf(this.readBlocks));
        Log.info(this, "  writeBlocks:     " + String.valueOf(this.writeBlocks));
        Log.info(this, "  iteratorBlocks:  " + String.valueOf(this.iteratorBlocks));
        Log.info(this, "  freedBlocks:     " + String.valueOf(this.freedBlocks));
    }

    @Override
    public void beginRead() {
        this.checkIfClosed();
        this.blockMgr.beginRead();
    }

    @Override
    public void endRead() {
        this.checkIfClosed();
        this.blockMgr.endRead();
    }

    @Override
    public void beginIterator(Iterator<?> iterator) {
        this.checkIfClosed();
        this.transaction.addIterator(iterator);
    }

    @Override
    public void endIterator(Iterator<?> iterator) {
        this.checkIfClosed();
        this.transaction.removeIterator(iterator);
    }

    public String toString() {
        return "Journal:" + this.fileRef.getFilename() + " (" + this.blockMgr.getClass().getSimpleName() + ")";
    }

    @Override
    public String getLabel() {
        return this.fileRef.getFilename();
    }

    private Block replicate(Block srcBlock) {
        ByteBuffer dstBuffer = this.writeBlockBufferAllocator.allocate(srcBlock.getByteBuffer().capacity());
        return srcBlock.replicate(dstBuffer);
    }
}

