/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.util.Properties;
import java.util.Set;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.tdb2.TDB2;

public class EnvTDB {
    static final String prefix = "tdb2:";

    public static void processGlobalSystemProperties() {
        Context context2 = EnvTDB.processProperties(System.getProperties());
        TDB2.getContext().putAll(context2);
    }

    public static Context processProperties(Properties properties) {
        Context context2 = new Context();
        Set<Object> keys = properties.keySet();
        for (Object key : keys) {
            if (!(key instanceof String)) continue;
            Object keyStr = (String)key;
            if (((String)keyStr).startsWith(prefix)) {
                keyStr = "http://jena.apache.org/TDB#" + ((String)keyStr).substring(prefix.length());
            }
            if (!((String)keyStr).startsWith("http://jena.apache.org/TDB#")) continue;
            Object value = properties.get(key);
            Symbol symbol = Symbol.create((String)keyStr);
            context2.set(symbol, value);
        }
        return context2;
    }
}

