/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;

public abstract class CharEncoding {
    static Set<String> macEncodings = new HashSet<String>();
    private String name;

    private CharEncoding() {
    }

    private CharEncoding(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public abstract boolean isIANA();

    public abstract boolean isInNIO();

    public abstract String warningMessage();

    public static CharEncoding create(String enc) {
        if (Charset.isSupported(enc)) {
            String nm = Charset.forName(enc).name();
            if (nm.charAt(1) == '-' && (nm.charAt(0) == 'x' || nm.charAt(0) == 'X')) {
                return new NonIANAnioEncoding(nm);
            }
            if (nm.startsWith("Mac") && macEncodings.contains(nm)) {
                return new NonIANAnioEncoding(nm);
            }
            return new IANAnioEncoding(nm);
        }
        return new NotNioEncoding(enc);
    }

    static {
        macEncodings.add("MacArabic");
        macEncodings.add("MacCentralEurope");
        macEncodings.add("MacCroatian");
        macEncodings.add("MacCyrillic");
        macEncodings.add("MacDingbat");
        macEncodings.add("MacGreek");
        macEncodings.add("MacHebrew");
        macEncodings.add("MacIceland");
        macEncodings.add("MacRoman");
        macEncodings.add("MacRomania");
        macEncodings.add("MacSymbol");
        macEncodings.add("MacThai");
        macEncodings.add("MacTurkish");
        macEncodings.add("MacUkraine");
    }

    private static class NonIANAnioEncoding
    extends CharEncoding {
        NonIANAnioEncoding(String name) {
            super(name);
        }

        @Override
        public boolean isIANA() {
            return false;
        }

        @Override
        public boolean isInNIO() {
            return true;
        }

        @Override
        public String warningMessage() {
            return "The encoding \"" + this.name() + "\" is not registered with IANA, and hence not suitable for Web content.";
        }
    }

    private static class IANAnioEncoding
    extends CharEncoding {
        IANAnioEncoding(String name) {
            super(name);
        }

        @Override
        public boolean isIANA() {
            return true;
        }

        @Override
        public boolean isInNIO() {
            return true;
        }

        @Override
        public String warningMessage() {
            return null;
        }
    }

    private static class NotNioEncoding
    extends CharEncoding {
        NotNioEncoding(String name) {
            super(name);
        }

        @Override
        public boolean isIANA() {
            return false;
        }

        @Override
        public boolean isInNIO() {
            return false;
        }

        @Override
        public String warningMessage() {
            return "The encoding \"" + this.name() + "\" is not fully supported; maybe try using Java 1.5 or higher (if you are not already).";
        }
    }
}

