/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.SingleOperation;

@XmlTransient
abstract class GeodeticOperation
extends AbstractProvider {
    private static final long serialVersionUID = -2030570546566544546L;
    private final int indexOfDim;
    static final int INDEX_OF_1D = -1;
    static final int INDEX_OF_2D = 0;
    static final int INDEX_OF_3D = 3;

    GeodeticOperation redimensioned(int indexOfDim) {
        return null;
    }

    @Deprecated
    GeodeticOperation(GeodeticOperation copy) {
        super(copy);
        this.indexOfDim = copy.indexOfDim;
    }

    GeodeticOperation(Class<? extends SingleOperation> operationType, ParameterDescriptorGroup parameters, int indexOfDim, Class<? extends CoordinateSystem> sourceCSType, boolean sourceOnEllipsoid, Class<? extends CoordinateSystem> targetCSType, boolean targetOnEllipsoid) {
        super(operationType, parameters, sourceCSType, sourceOnEllipsoid, targetCSType, targetOnEllipsoid);
        this.indexOfDim = indexOfDim;
    }

    @Override
    public final Integer getSourceDimensions() {
        if (this.indexOfDim >= 0) {
            return (this.indexOfDim >>> 1) + 2;
        }
        return 1;
    }

    @Override
    public final Integer getTargetDimensions() {
        if (this.indexOfDim >= 0) {
            return (this.indexOfDim & 1) + 2;
        }
        return 1;
    }

    @Override
    public final AbstractProvider redimension(int sourceDimensions, int targetDimensions) {
        int i = sourceDimensions - 2 << 1 | targetDimensions - 2;
        if (i >= 0 && i <= 3) {
            if (i == this.indexOfDim) {
                return this;
            }
            GeodeticOperation redimensioned = this.redimensioned(i);
            if (redimensioned != null) {
                assert (redimensioned.getSourceDimensions() == sourceDimensions) : sourceDimensions;
                assert (redimensioned.getTargetDimensions() == targetDimensions) : targetDimensions;
                return redimensioned;
            }
        }
        return super.redimension(sourceDimensions, targetDimensions);
    }

    @Override
    public AbstractProvider inverse() {
        return this;
    }
}

