/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.sis.util.ArgumentChecks;

public class Version
implements CharSequence,
Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 8402041502662929792L;
    private static final String SEPARATORS = ".-";
    public static final Version SIS = new Version("1.4");
    private static final Version[] CONSTANTS = new Version[]{new Version("1"), new Version("2"), new Version("1.0"), new Version("1.1")};
    private final String version;
    private transient String[] components;
    private transient Comparable<?>[] parsed;
    private transient int hashCode;

    public Version(String version2) {
        ArgumentChecks.ensureNonNull("version", version2);
        this.version = version2;
    }

    public static Version valueOf(int ... components) {
        int i;
        Version version2;
        ArgumentChecks.ensureNonEmptyBounded("components", false, Integer.MIN_VALUE, Integer.MAX_VALUE, components);
        int major = components[0];
        if (components.length == 1) {
            if (major >= 1 && major <= CONSTANTS.length) {
                return CONSTANTS[major - 1];
            }
            version2 = new Version(Integer.toString(major));
        } else {
            StringBuilder buffer = new StringBuilder().append(major);
            for (i = 1; i < components.length; ++i) {
                buffer.append('.').append(components[i]);
            }
            version2 = new Version(buffer.toString());
        }
        Integer[] parsed = new Integer[components.length];
        for (i = 0; i < components.length; ++i) {
            parsed[i] = components[i];
        }
        version2.parsed = parsed;
        return version2;
    }

    public Comparable<?> getMajor() {
        return this.getComponent(0);
    }

    public Comparable<?> getMinor() {
        return this.getComponent(1);
    }

    public Comparable<?> getRevision() {
        return this.getComponent(2);
    }

    final synchronized Comparable<?> getComponent(int index) {
        if (this.parsed == null) {
            if (this.components == null) {
                StringTokenizer tokens2 = new StringTokenizer(this.version, SEPARATORS);
                this.components = new String[tokens2.countTokens()];
                int i = 0;
                while (tokens2.hasMoreTokens()) {
                    this.components[i] = tokens2.nextToken();
                    ++i;
                }
            }
            this.parsed = new Comparable[this.components.length];
        }
        if (index >= this.parsed.length) {
            return null;
        }
        Object candidate = this.parsed[index];
        if (candidate == null) {
            String value = this.components[index].strip();
            try {
                candidate = Integer.valueOf(value);
            }
            catch (NumberFormatException e2) {
                candidate = value;
            }
            this.parsed[index] = candidate;
        }
        return candidate;
    }

    private static int getTypeRank(Object value) {
        if (value instanceof CharSequence) {
            return 0;
        }
        if (value instanceof Number) {
            return 1;
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    public int compareTo(Version other, int limit) {
        ArgumentChecks.ensureNonNull("other", other);
        ArgumentChecks.ensurePositive("limit", limit);
        for (int i = 0; i < limit; ++i) {
            Comparable<?> v1 = this.getComponent(i);
            Comparable<?> v2 = other.getComponent(i);
            if (v1 == null) {
                return v2 == null ? 0 : -1;
            }
            if (v2 == null) {
                return 1;
            }
            int dr = Version.getTypeRank(v1) - Version.getTypeRank(v2);
            if (dr != 0) {
                return dr;
            }
            int c = v1.compareTo(v2);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public int compareTo(Version other) {
        return this.compareTo(other, Integer.MAX_VALUE);
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            return this.compareTo((Version)other) == 0;
        }
        return false;
    }

    @Override
    public int length() {
        return this.version.length();
    }

    @Override
    public char charAt(int index) {
        return this.version.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.version.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.version;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            Comparable<?> component;
            int code = 307244416;
            int index = 0;
            while ((component = this.getComponent(index)) != null) {
                code = code * 31 + component.hashCode();
                ++index;
            }
            if (code == 0) {
                code = -1;
            }
            this.hashCode = code;
        }
        return this.hashCode;
    }
}

