/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.Serializable;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _sessionRenewedOnAuthentication;
    private int _sessionMaxInactiveIntervalOnAuthentication;
    private boolean _proxy;

    protected LoginAuthenticator() {
    }

    public boolean isProxyMode() {
        return this._proxy;
    }

    public void setProxyMode(boolean proxy) {
        this._proxy = proxy;
    }

    public HttpHeader getAuthorizationHeader() {
        return this._proxy ? HttpHeader.PROXY_AUTHORIZATION : HttpHeader.AUTHORIZATION;
    }

    public HttpHeader getChallengeHeader() {
        return this._proxy ? HttpHeader.PROXY_AUTHENTICATE : HttpHeader.WWW_AUTHENTICATE;
    }

    public int getUnauthorizedStatusCode() {
        return this._proxy ? 407 : 401;
    }

    public UserIdentity login(String username, Object password, Request request, Response response) {
        UserIdentity user = this._loginService.login(username, password, request, request::getSession);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.login {}", (Object)this, (Object)user);
        }
        if (user != null) {
            this.updateSession(request, response);
            return user;
        }
        return null;
    }

    public void logout(Request request, Response response) {
        Session session = request.getSession(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}.logout {}", (Object)this, (Object)session);
        }
        if (session == null) {
            return;
        }
        session.removeAttribute(SecurityHandler.SESSION_AUTHENTICATED_ATTRIBUTE);
    }

    @Override
    public void setConfiguration(Authenticator.Configuration configuration) {
        if (this._loginService == null) {
            this._loginService = configuration.getLoginService();
        }
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._sessionRenewedOnAuthentication = configuration.isSessionRenewedOnAuthentication();
        this._sessionMaxInactiveIntervalOnAuthentication = configuration.getSessionMaxInactiveIntervalOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        this._loginService = loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSession(Request httpRequest, Response httpResponse) {
        Session session = httpRequest.getSession(false);
        if (session != null && (this._sessionRenewedOnAuthentication || this._sessionMaxInactiveIntervalOnAuthentication != 0)) {
            Session session2 = session;
            synchronized (session2) {
                if (this._sessionMaxInactiveIntervalOnAuthentication != 0) {
                    session.setMaxInactiveInterval(this._sessionMaxInactiveIntervalOnAuthentication < 0 ? -1 : this._sessionMaxInactiveIntervalOnAuthentication);
                }
                if (this._sessionRenewedOnAuthentication && session.getAttribute(SecurityHandler.SESSION_AUTHENTICATED_ATTRIBUTE) != Boolean.TRUE) {
                    session.setAttribute(SecurityHandler.SESSION_AUTHENTICATED_ATTRIBUTE, Boolean.TRUE);
                    session.renewId(httpRequest, httpResponse);
                }
            }
        }
    }

    public static class LoggedOutAuthentication
    implements AuthenticationState.Deferred {
        private final AuthenticationState.Deferred _delegate;

        @Override
        public AuthenticationState.Succeeded login(String username, Object password, Request request, Response response) {
            return this._delegate.login(username, password, request, response);
        }

        @Override
        public void logout(Request request, Response response) {
            this._delegate.logout(request, response);
        }

        @Override
        public IdentityService.Association getAssociation() {
            return this._delegate.getAssociation();
        }

        public LoggedOutAuthentication(LoginAuthenticator authenticator) {
            this._delegate = AuthenticationState.defer(authenticator);
        }

        @Override
        public AuthenticationState.Succeeded authenticate(Request request) {
            return null;
        }

        @Override
        public AuthenticationState authenticate(Request request, Response response, Callback callback) {
            return null;
        }
    }

    public static class UserAuthenticationSent
    extends UserAuthenticationSucceeded
    implements AuthenticationState.ResponseSent {
        public UserAuthenticationSent(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }
    }

    public static class UserAuthenticationSucceeded
    implements AuthenticationState.Succeeded,
    Serializable {
        private static final long serialVersionUID = -6290411814232723403L;
        protected String _authenticationType;
        protected transient UserIdentity _userIdentity;

        public UserAuthenticationSucceeded(String authenticationType, UserIdentity userIdentity) {
            this._authenticationType = authenticationType;
            this._userIdentity = userIdentity;
        }

        @Override
        public String getAuthenticationType() {
            return this._authenticationType;
        }

        @Override
        public UserIdentity getUserIdentity() {
            return this._userIdentity;
        }

        @Override
        public boolean isUserInRole(String role) {
            return this._userIdentity.isUserInRole(role);
        }

        @Override
        public void logout(Request request, Response response) {
            SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
            if (security != null) {
                IdentityService identityService;
                LoginService loginService = security.getLoginService();
                if (loginService != null) {
                    loginService.logout(this.getUserIdentity());
                }
                if ((identityService = security.getIdentityService()) != null) {
                    identityService.onLogout(this.getUserIdentity());
                }
                Authenticator authenticator = security.getAuthenticator();
                LoggedOutAuthentication authenticationState = null;
                if (authenticator instanceof LoginAuthenticator) {
                    LoginAuthenticator loginAuthenticator = (LoginAuthenticator)authenticator;
                    ((LoginAuthenticator)authenticator).logout(request, response);
                    authenticationState = new LoggedOutAuthentication(loginAuthenticator);
                }
                AuthenticationState.setAuthenticationState(request, authenticationState);
            }
        }

        public String toString() {
            return "%s@%x{%s,%s}".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getAuthenticationType(), this.getUserIdentity());
        }
    }
}

