/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.flattening.Flattening;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.processor.CompactionProcessor;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import jakarta.json.JsonArray;
import jakarta.json.JsonStructure;
import java.net.URI;

public final class FlatteningProcessor {
    private FlatteningProcessor() {
    }

    public static final JsonStructure flatten(URI input, URI context2, JsonLdOptions options) throws JsonLdError {
        if (context2 == null) {
            return FlatteningProcessor.flatten(input, (Document)null, options);
        }
        FlatteningProcessor.assertDocumentLoader(options, input);
        Document contextDocument = options.getDocumentLoader().loadDocument(context2, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Context[" + String.valueOf(context2) + "] is null.");
        }
        return FlatteningProcessor.flatten(input, contextDocument, options);
    }

    public static final JsonStructure flatten(Document input, URI context2, JsonLdOptions options) throws JsonLdError {
        if (context2 == null) {
            return FlatteningProcessor.flatten(input, (Document)null, options);
        }
        FlatteningProcessor.assertDocumentLoader(options, context2);
        Document contextDocument = options.getDocumentLoader().loadDocument(context2, new DocumentLoaderOptions());
        if (contextDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Context[" + String.valueOf(context2) + "] is null.");
        }
        return FlatteningProcessor.flatten(input, contextDocument, options);
    }

    public static final JsonStructure flatten(URI input, Document context2, JsonLdOptions options) throws JsonLdError {
        FlatteningProcessor.assertDocumentLoader(options, input);
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(input, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED);
        }
        return FlatteningProcessor.flatten(remoteDocument, context2, options);
    }

    public static final JsonStructure flatten(Document input, Document context2, JsonLdOptions options) throws JsonLdError {
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        JsonStructure flattenedOutput = Flattening.with(expandedInput).ordered(options.isOrdered()).flatten();
        if (context2 != null) {
            JsonDocument document = JsonDocument.of(MediaType.JSON_LD, flattenedOutput);
            JsonLdOptions compactionOptions = new JsonLdOptions(options);
            if (options.getBase() != null) {
                compactionOptions.setBase(options.getBase());
            } else if (options.isCompactArrays()) {
                compactionOptions.setBase(input.getDocumentUrl());
            }
            flattenedOutput = CompactionProcessor.compact((Document)document, context2, compactionOptions);
        }
        return flattenedOutput;
    }

    private static final void assertDocumentLoader(JsonLdOptions options, URI target) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + String.valueOf(target) + "].");
        }
    }
}

