/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.List;
import com.github.andrewoma.dexx.collection.internal.base.AbstractIndexedList;
import com.github.andrewoma.dexx.collection.internal.builder.AbstractBuilder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayList<E>
extends AbstractIndexedList<E> {
    private static final ArrayList<Object> EMPTY = new ArrayList();
    private final Object[] elements;

    public static <E> ArrayList<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> BuilderFactory<E, ArrayList<E>> factory() {
        return new BuilderFactory<E, ArrayList<E>>(){

            @Override
            @NotNull
            public Builder<E, ArrayList<E>> newBuilder() {
                return new AbstractBuilder<E, ArrayList<E>>(){
                    private java.util.List<E> buffer = new java.util.ArrayList();

                    @Override
                    @NotNull
                    public Builder<E, ArrayList<E>> add(E element) {
                        this.buffer.add(element);
                        return this;
                    }

                    @Override
                    @NotNull
                    public ArrayList<E> doBuild() {
                        return new ArrayList(this.buffer.toArray(new Object[this.buffer.size()]));
                    }
                };
            }
        };
    }

    public ArrayList() {
        this(new Object[0]);
    }

    ArrayList(Object[] elements) {
        this.elements = elements;
    }

    @Override
    @NotNull
    public ArrayList<E> set(int i, E elem) {
        Object old = this.elements[i];
        if (old == elem) {
            return this;
        }
        int len = this.elements.length;
        Object[] newElements = Arrays.copyOf(this.elements, len);
        newElements[i] = elem;
        return new ArrayList<E>(newElements);
    }

    @Override
    @NotNull
    public ArrayList<E> append(E elem) {
        int len = this.elements.length;
        Object[] newElements = Arrays.copyOf(this.elements, len + 1);
        newElements[len] = elem;
        return new ArrayList<E>(newElements);
    }

    @Override
    @NotNull
    public ArrayList<E> prepend(E elem) {
        int len = this.elements.length;
        Object[] newElements = new Object[len + 1];
        System.arraycopy(this.elements, 0, newElements, 1, len);
        newElements[0] = elem;
        return new ArrayList<E>(newElements);
    }

    @Override
    @NotNull
    public ArrayList<E> drop(int number) {
        if ((number = Math.max(number, 0)) >= this.elements.length) {
            return ArrayList.empty();
        }
        int len = this.elements.length - number;
        Object[] newElements = new Object[len];
        System.arraycopy(this.elements, number, newElements, 0, len);
        return new ArrayList<E>(newElements);
    }

    @Override
    @NotNull
    public ArrayList<E> take(int number) {
        number = Math.min(number, this.elements.length);
        if ((number = Math.max(number, 0)) == 0) {
            return ArrayList.empty();
        }
        Object[] newElements = Arrays.copyOf(this.elements, number);
        return new ArrayList<E>(newElements);
    }

    @Override
    @NotNull
    public ArrayList<E> range(int from, boolean fromInclusive, int to, boolean toInclusive) {
        if (this.isEmpty()) {
            return this;
        }
        from = fromInclusive ? from : from + 1;
        from = Math.max(from, 0);
        from = Math.min(from, this.elements.length - 1);
        to = toInclusive ? to : to - 1;
        to = Math.max(to, 0);
        if ((to = Math.min(to, this.elements.length - 1)) < from) {
            return ArrayList.empty();
        }
        int len = to - from + 1;
        Object[] newElements = Arrays.copyOf(this.elements, len);
        System.arraycopy(this.elements, from, newElements, 0, len);
        return new ArrayList<E>(newElements);
    }

    @Override
    public E get(int i) {
        return (E)this.elements[i];
    }

    @Override
    @Nullable
    public E first() {
        return (E)(this.elements.length == 0 ? null : this.elements[0]);
    }

    @Override
    @Nullable
    public E last() {
        return (E)(this.elements.length == 0 ? null : this.elements[this.elements.length - 1]);
    }

    @Override
    @NotNull
    public List<E> tail() {
        if (this.isEmpty()) {
            return this;
        }
        if (this.size() == 1) {
            return ArrayList.empty();
        }
        int len = this.elements.length - 1;
        Object[] newElements = new Object[len];
        System.arraycopy(this.elements, 1, newElements, 0, len);
        return new ArrayList<E>(newElements);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int current = -1;

            @Override
            public boolean hasNext() {
                return this.current != ArrayList.this.elements.length - 1;
            }

            @Override
            public E next() {
                if (this.current == ArrayList.this.elements.length - 1) {
                    throw new NoSuchElementException();
                }
                ++this.current;
                return ArrayList.this.elements[this.current];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.length == 0;
    }
}

