/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.CommandInfo;
import jakarta.activation.CommandMap;
import jakarta.activation.DataContentHandler;
import jakarta.activation.FactoryFinder;
import jakarta.activation.LogSupport;
import jakarta.activation.MailcapRegistry;
import jakarta.activation.SecuritySupport;
import jakarta.activation.spi.MailcapRegistryProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;

public class MailcapCommandMap
extends CommandMap {
    private MailcapRegistry[] DB;
    private static final int PROG = 0;
    private static final String confDir;

    public MailcapCommandMap() {
        MailcapRegistry mf;
        ArrayList<MailcapRegistry> dbv;
        block8: {
            block7: {
                dbv = new ArrayList<MailcapRegistry>(5);
                mf = null;
                dbv.add(null);
                LogSupport.log("MailcapCommandMap: load HOME");
                try {
                    String[] paths;
                    String user_home = System.getProperty("user.home");
                    if (user_home == null) break block7;
                    String[] stringArray = paths = new String[]{user_home + File.separator + ".jakarta.mailcap", user_home + File.separator + ".mailcap"};
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String path = stringArray[i];
                        mf = this.loadFile(path);
                        if (mf == null) continue;
                        dbv.add(mf);
                        break;
                    }
                }
                catch (SecurityException user_home) {
                    // empty catch block
                }
            }
            LogSupport.log("MailcapCommandMap: load SYS");
            try {
                String[] confs;
                if (confDir == null) break block8;
                for (String conf : confs = new String[]{"jakarta.mailcap", "mailcap"}) {
                    mf = this.loadFile(confDir + conf);
                    if (mf == null) continue;
                    dbv.add(mf);
                    break;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        LogSupport.log("MailcapCommandMap: load JAR");
        this.loadAllResources(dbv, "META-INF/jakarta.mailcap", "META-INF/mailcap");
        LogSupport.log("MailcapCommandMap: load DEF");
        mf = this.loadResource("/META-INF/jakarta.mailcap.default", "/META-INF/mailcap.default");
        if (mf != null) {
            dbv.add(mf);
        }
        this.DB = new MailcapRegistry[dbv.size()];
        this.DB = dbv.toArray(this.DB);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MailcapRegistry loadResource(String ... names) {
        String[] stringArray = names;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                String name = stringArray[n2];
                try (InputStream clis = SecuritySupport.getResourceAsStream(this.getClass(), name);){
                    if (clis != null) {
                        MailcapRegistry mf = this.getImplementation().getByInputStream(clis);
                        if (LogSupport.isLoggable()) {
                            LogSupport.log("MailcapCommandMap: successfully loaded jakarta.mailcap file: " + name);
                        }
                        MailcapRegistry mailcapRegistry = mf;
                        return mailcapRegistry;
                    }
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MailcapCommandMap: not loading jakarta.mailcap file: " + name);
                    }
                }
                catch (IOException | SecurityException e2) {
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MailcapCommandMap: can't load " + name, e2);
                    }
                }
                catch (IllegalStateException | NoSuchElementException | ServiceConfigurationError e3) {
                    if (!LogSupport.isLoggable()) break block15;
                    LogSupport.log("Cannot find or load an implementation for MailcapRegistryProvider. MailcapRegistry: can't load " + name, e3);
                }
            }
            ++n2;
        }
        return null;
    }

    private void loadAllResources(List<MailcapRegistry> v, String ... names) {
        boolean anyLoaded = false;
        for (String name : names) {
            try {
                URL[] urls;
                ClassLoader cld = null;
                cld = SecuritySupport.getContextClassLoader();
                if (cld == null) {
                    cld = this.getClass().getClassLoader();
                }
                if ((urls = cld != null ? SecuritySupport.getResources(cld, name) : SecuritySupport.getSystemResources(name)) == null) continue;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MailcapCommandMap: getResources");
                }
                for (int i = 0; i < urls.length; ++i) {
                    URL url = urls[i];
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MailcapCommandMap: URL " + url);
                    }
                    try (InputStream clis = SecuritySupport.openStream(url);){
                        if (clis != null) {
                            v.add(this.getImplementation().getByInputStream(clis));
                            anyLoaded = true;
                            if (LogSupport.isLoggable()) {
                                LogSupport.log("MailcapCommandMap: successfully loaded jakarta.mailcap file from URL: " + url);
                            }
                            continue;
                        }
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MailcapCommandMap: not loading jakarta.mailcap file from URL: " + url);
                        continue;
                    }
                    catch (IOException | SecurityException ioex) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MailcapCommandMap: can't load " + url, ioex);
                        continue;
                    }
                    catch (IllegalStateException | NoSuchElementException | ServiceConfigurationError e2) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("Cannot find or load an implementation for MailcapRegistryProvider. MailcapRegistry: can't load " + name, e2);
                    }
                }
                break;
            }
            catch (Exception ex) {
                if (!LogSupport.isLoggable()) continue;
                LogSupport.log("MailcapCommandMap: can't load " + name, ex);
            }
        }
        if (!anyLoaded) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: !anyLoaded");
            }
            String[] resources = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                resources[i] = "/" + names[i];
            }
            MailcapRegistry mf = this.loadResource(resources);
            if (mf != null) {
                v.add(mf);
            }
        }
    }

    private MailcapRegistry loadFile(String name) {
        MailcapRegistry mtf;
        block4: {
            mtf = null;
            try {
                mtf = this.getImplementation().getByFileName(name);
            }
            catch (IOException e2) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MailcapRegistry: can't load from file - " + name, e2);
                }
            }
            catch (IllegalStateException | NoSuchElementException | ServiceConfigurationError e3) {
                if (!LogSupport.isLoggable()) break block4;
                LogSupport.log("Cannot find or load an implementation for MailcapRegistryProvider. MailcapRegistry: can't load " + name, e3);
            }
        }
        return mtf;
    }

    public MailcapCommandMap(String fileName) throws IOException {
        this();
        if (this.DB[0] == null) {
            try {
                this.DB[0] = this.getImplementation().getByFileName(fileName);
            }
            catch (IllegalStateException | NoSuchElementException | ServiceConfigurationError e2) {
                String message = "Cannot find or load an implementation for MailcapRegistryProvider. MailcapRegistry: can't load " + fileName;
                if (LogSupport.isLoggable()) {
                    LogSupport.log(message, e2);
                }
                throw new IOException(message, e2);
            }
        }
        if (this.DB[0] != null && LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: load PROG from " + fileName);
        }
    }

    public MailcapCommandMap(InputStream is) {
        block5: {
            this();
            if (this.DB[0] == null) {
                try {
                    this.DB[0] = this.getImplementation().getByInputStream(is);
                }
                catch (IOException iOException) {
                }
                catch (IllegalStateException | NoSuchElementException | ServiceConfigurationError e2) {
                    if (!LogSupport.isLoggable()) break block5;
                    LogSupport.log("Cannot find or load an implementation for MailcapRegistryProvider.MailcapRegistry: can't load InputStream", e2);
                }
            }
        }
        if (this.DB[0] != null && LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: load PROG");
        }
    }

    @Override
    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
        Map<String, List<String>> cmdMap;
        int i;
        ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        for (i = 0; i < this.DB.length; ++i) {
            if (this.DB[i] == null || (cmdMap = this.DB[i].getMailcapList(mimeType)) == null) continue;
            this.appendPrefCmdsToList(cmdMap, cmdList);
        }
        for (i = 0; i < this.DB.length; ++i) {
            if (this.DB[i] == null || (cmdMap = this.DB[i].getMailcapFallbackList(mimeType)) == null) continue;
            this.appendPrefCmdsToList(cmdMap, cmdList);
        }
        CommandInfo[] cmdInfos = new CommandInfo[cmdList.size()];
        cmdInfos = cmdList.toArray(cmdInfos);
        return cmdInfos;
    }

    private void appendPrefCmdsToList(Map<String, List<String>> cmdHash, List<CommandInfo> cmdList) {
        for (String verb : cmdHash.keySet()) {
            if (this.checkForVerb(cmdList, verb)) continue;
            List<String> cmdList2 = cmdHash.get(verb);
            String className = cmdList2.get(0);
            cmdList.add(new CommandInfo(verb, className));
        }
    }

    private boolean checkForVerb(List<CommandInfo> cmdList, String verb) {
        Iterator<CommandInfo> ee = cmdList.iterator();
        while (ee.hasNext()) {
            String enum_verb = ee.next().getCommandName();
            if (!enum_verb.equals(verb)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized CommandInfo[] getAllCommands(String mimeType) {
        Map<String, List<String>> cmdMap;
        int i;
        ArrayList<CommandInfo> cmdList = new ArrayList<CommandInfo>();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        for (i = 0; i < this.DB.length; ++i) {
            if (this.DB[i] == null || (cmdMap = this.DB[i].getMailcapList(mimeType)) == null) continue;
            this.appendCmdsToList(cmdMap, cmdList);
        }
        for (i = 0; i < this.DB.length; ++i) {
            if (this.DB[i] == null || (cmdMap = this.DB[i].getMailcapFallbackList(mimeType)) == null) continue;
            this.appendCmdsToList(cmdMap, cmdList);
        }
        CommandInfo[] cmdInfos = new CommandInfo[cmdList.size()];
        cmdInfos = cmdList.toArray(cmdInfos);
        return cmdInfos;
    }

    private void appendCmdsToList(Map<String, List<String>> typeHash, List<CommandInfo> cmdList) {
        for (String verb : typeHash.keySet()) {
            List<String> cmdList2 = typeHash.get(verb);
            for (String cmd2 : cmdList2) {
                cmdList.add(new CommandInfo(verb, cmd2));
            }
        }
    }

    @Override
    public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
        String cmdClassName;
        List<String> v;
        Map<String, List<String>> cmdMap;
        int i;
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        for (i = 0; i < this.DB.length; ++i) {
            if (this.DB[i] == null || (cmdMap = this.DB[i].getMailcapList(mimeType)) == null || (v = cmdMap.get(cmdName)) == null || (cmdClassName = v.get(0)) == null) continue;
            return new CommandInfo(cmdName, cmdClassName);
        }
        for (i = 0; i < this.DB.length; ++i) {
            if (this.DB[i] == null || (cmdMap = this.DB[i].getMailcapFallbackList(mimeType)) == null || (v = cmdMap.get(cmdName)) == null || (cmdClassName = v.get(0)) == null) continue;
            return new CommandInfo(cmdName, cmdClassName);
        }
        return null;
    }

    public synchronized void addMailcap(String mail_cap) {
        LogSupport.log("MailcapCommandMap: add to PROG");
        try {
            if (this.DB[0] == null) {
                this.DB[0] = this.getImplementation().getInMemory();
            }
            this.DB[0].appendToMailcap(mail_cap);
        }
        catch (IllegalStateException | NoSuchElementException | ServiceConfigurationError e2) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("Cannot find or load an implementation for MailcapRegistryProvider. MailcapRegistry: can't load", e2);
            }
            throw e2;
        }
    }

    @Override
    public synchronized DataContentHandler createDataContentHandler(String mimeType) {
        String name;
        DataContentHandler dch;
        List<String> v;
        Map<String, List<String>> cmdMap;
        int i;
        if (LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: createDataContentHandler for " + mimeType);
        }
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        for (i = 0; i < this.DB.length; ++i) {
            if (this.DB[i] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("  search DB #" + i);
            }
            if ((cmdMap = this.DB[i].getMailcapList(mimeType)) == null || (v = cmdMap.get("content-handler")) == null || (dch = this.getDataContentHandler(name = v.get(0))) == null) continue;
            return dch;
        }
        for (i = 0; i < this.DB.length; ++i) {
            if (this.DB[i] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("  search fallback DB #" + i);
            }
            if ((cmdMap = this.DB[i].getMailcapFallbackList(mimeType)) == null || (v = cmdMap.get("content-handler")) == null || (dch = this.getDataContentHandler(name = v.get(0))) == null) continue;
            return dch;
        }
        return null;
    }

    private DataContentHandler getDataContentHandler(String name) {
        block8: {
            if (LogSupport.isLoggable()) {
                LogSupport.log("    got content-handler");
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log("      class " + name);
            }
            try {
                ClassLoader cld = null;
                cld = SecuritySupport.getContextClassLoader();
                if (cld == null) {
                    cld = this.getClass().getClassLoader();
                }
                Class<?> cl = null;
                try {
                    cl = cld.loadClass(name);
                }
                catch (Exception ex) {
                    cl = Class.forName(name);
                }
                if (cl != null) {
                    return (DataContentHandler)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ReflectiveOperationException e2) {
                if (!LogSupport.isLoggable()) break block8;
                LogSupport.log("Can't load DCH " + name, e2);
            }
        }
        return null;
    }

    @Override
    public synchronized String[] getMimeTypes() {
        ArrayList<String> mtList = new ArrayList<String>();
        for (int i = 0; i < this.DB.length; ++i) {
            String[] ts;
            if (this.DB[i] == null || (ts = this.DB[i].getMimeTypes()) == null) continue;
            for (int j = 0; j < ts.length; ++j) {
                if (mtList.contains(ts[j])) continue;
                mtList.add(ts[j]);
            }
        }
        String[] mts = new String[mtList.size()];
        mts = mtList.toArray(mts);
        return mts;
    }

    public synchronized String[] getNativeCommands(String mimeType) {
        ArrayList<String> cmdList = new ArrayList<String>();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase(Locale.ENGLISH);
        }
        for (int i = 0; i < this.DB.length; ++i) {
            String[] cmds;
            if (this.DB[i] == null || (cmds = this.DB[i].getNativeCommands(mimeType)) == null) continue;
            for (int j = 0; j < cmds.length; ++j) {
                if (cmdList.contains(cmds[j])) continue;
                cmdList.add(cmds[j]);
            }
        }
        String[] cmds = new String[cmdList.size()];
        cmds = cmdList.toArray(cmds);
        return cmds;
    }

    private MailcapRegistryProvider getImplementation() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<MailcapRegistryProvider>(){

                @Override
                public MailcapRegistryProvider run() {
                    return FactoryFinder.find(MailcapRegistryProvider.class);
                }
            });
        }
        return FactoryFinder.find(MailcapRegistryProvider.class);
    }

    static {
        String dir = null;
        try {
            dir = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String home = System.getProperty("java.home");
                    String newdir = home + File.separator + "conf";
                    File conf = new File(newdir);
                    if (conf.exists()) {
                        return newdir + File.separator;
                    }
                    return home + File.separator + "lib" + File.separator;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        confDir = dir;
    }
}

