/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.collections4.Transformer;

public class ConstantTransformer<T, R>
implements Transformer<T, R>,
Serializable {
    private static final long serialVersionUID = 6374440726369055124L;
    public static final Transformer NULL_INSTANCE = new ConstantTransformer(null);
    private final R iConstant;

    public static <I, O> Transformer<I, O> constantTransformer(O constantToReturn) {
        if (constantToReturn == null) {
            return ConstantTransformer.nullTransformer();
        }
        return new ConstantTransformer(constantToReturn);
    }

    public static <I, O> Transformer<I, O> nullTransformer() {
        return NULL_INSTANCE;
    }

    public ConstantTransformer(R constantToReturn) {
        this.iConstant = constantToReturn;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConstantTransformer)) {
            return false;
        }
        R otherConstant = ((ConstantTransformer)obj).getConstant();
        return Objects.equals(otherConstant, this.getConstant());
    }

    public R getConstant() {
        return this.iConstant;
    }

    public int hashCode() {
        int result = "ConstantTransformer".hashCode() << 2;
        if (this.getConstant() != null) {
            result |= this.getConstant().hashCode();
        }
        return result;
    }

    @Override
    public R transform(T input) {
        return this.iConstant;
    }
}

