/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.auth;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.jena.fuseki.auth.AuthPolicy;

class AuthUserList
implements AuthPolicy {
    private final Set<String> allowedUsers;

    AuthUserList(Collection<String> allowed) {
        this.allowedUsers = allowed == null ? Collections.emptySet() : Set.copyOf(allowed);
    }

    @Override
    public boolean isAllowed(String user) {
        if (user == null) {
            return false;
        }
        return AuthUserList.contains(this.allowedUsers, user);
    }

    @Override
    public boolean isDenied(String user) {
        return !this.isAllowed(user);
    }

    static <T> boolean isNullOrEmpty(Collection<T> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    static <T> boolean contains(Collection<T> collection, T obj) {
        if (collection == null) {
            return false;
        }
        return collection.contains(obj);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "Users:(", ")");
        this.allowedUsers.stream().forEach(policy -> sj.add(policy.toString()));
        return sj.toString();
    }
}

