/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.mgt.FusekiServerCtl;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNull;
import org.apache.jena.system.Txn;

public class Backup {
    private static Set<DatasetGraph> activeBackups = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final boolean USE_GZIP = true;

    public static String chooseFileName(String dsName) {
        String ds = dsName;
        if (ds.startsWith("/")) {
            ds = ds.substring(1);
        }
        if (ds.contains("/")) {
            Fuseki.adminLog.warn("Dataset name: weird format: " + dsName);
            ds = ds.replace("/", "_");
        }
        String timestamp = DateTimeUtils.nowAsString("yyyy-MM-dd_HH-mm-ss");
        Object filename = ds + "_" + timestamp;
        filename = FusekiServerCtl.dirBackups.resolve((String)filename).toString();
        return filename;
    }

    public static void backup(Transactional transactional, DatasetGraph dsg, String backupfile) {
        if (transactional == null) {
            transactional = new TransactionalNull();
        }
        Txn.executeRead(transactional, () -> Backup.backup(dsg, backupfile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backup(DatasetGraph dsg, String backupfile) {
        if (dsg == null) {
            throw new FusekiException("No dataset provided to backup");
        }
        Set<DatasetGraph> set = activeBackups;
        synchronized (set) {
            if (activeBackups.contains(dsg)) {
                FmtLog.warn(Fuseki.serverLog, "Backup already in progress", new Object[0]);
            }
            activeBackups.add(dsg);
        }
        if (!((String)backupfile).endsWith(".nq")) {
            backupfile = (String)backupfile + ".nq";
        }
        backupfile = (String)backupfile + ".gz";
        try {
            IOX.safeWrite(Path.of((String)backupfile, new String[0]), outfile -> {
                OutputStream out = outfile;
                out = new GZIPOutputStream((OutputStream)outfile, 8192);
                try (BufferedOutputStream out2 = new BufferedOutputStream(out);){
                    RDFDataMgr.write((OutputStream)out2, dsg, Lang.NQUADS);
                }
            });
        }
        finally {
            set = activeBackups;
            synchronized (set) {
                activeBackups.remove(dsg);
            }
        }
    }
}

