/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.function.Function;
import org.apache.jena.fuseki.server.ValidString;
import org.apache.jena.fuseki.server.Validator;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIs;
import org.apache.jena.rfc3986.Chars3986;

public class Validators {
    private static Function<String, Boolean> fServiceName = Validators::isPath;
    private static Validator vServiceName = new Validator(ValidationPolicy.SERVICE, Validators::isPath);
    private static Function<String, Boolean> fEndpointName = epName -> epName == null || Validators.isPath(epName);
    private static Validator vEndpointName = new Validator(ValidationPolicy.ENDPOINT, fEndpointName);
    private static Function<String, Boolean> fGraphName = str2 -> {
        try {
            return IRIs.check(str2);
        }
        catch (IRIException ex) {
            return false;
        }
    };
    private static Validator vGraphName = new Validator(ValidationPolicy.GRAPH, fGraphName);

    public static ValidString serviceName(String name) {
        return ValidString.create(name, vServiceName);
    }

    public static ValidString endpointName(String name) {
        return ValidString.create(name, vEndpointName);
    }

    public static ValidString graphName(String name) {
        return ValidString.create(name, vGraphName);
    }

    private static boolean isPath(String str2) {
        if (str2 == null) {
            return false;
        }
        int N = str2.length();
        for (int i = 0; i < N; ++i) {
            char ch = str2.charAt(i);
            if (ch == '/' || Validators.isSegmentChar(ch, str2, i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSegment(String str2) {
        if (str2 == null) {
            return false;
        }
        int N = str2.length();
        for (int i = 0; i < N; ++i) {
            char ch = str2.charAt(i);
            if (Validators.isSegmentChar(ch, str2, i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSegmentChar(char ch, String str2, int posn) {
        return Chars3986.isPChar(ch, str2, posn);
    }

    static enum ValidationPolicy {
        SERVICE("service"),
        ENDPOINT("endpoint"),
        GRAPH("graph");

        final String label;

        private ValidationPolicy(String string2) {
            this.label = string2;
        }
    }
}

