/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIterator;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.UploadDetails;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.lang.StreamRDFCounting;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;

public class DataUploader {
    public static UploadDetails incomingData(HttpAction action, StreamRDF dest) {
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No content type");
            return null;
        }
        if (WebContent.matchContentType(WebContent.ctMultipartFormData, ct) || WebContent.matchContentType(WebContent.ctMultipartMixed, ct)) {
            return DataUploader.multipartCommonsFileUpload(action, dest);
        }
        String base = ActionLib.wholeRequestURL(action.getRequest());
        Lang lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
        if (lang == null) {
            ServletOps.errorBadRequest("Unknown content type for triples: " + String.valueOf(ct));
            return null;
        }
        long len = action.getRequestContentLengthLong();
        StreamRDFCounting countingDest = StreamRDFLib.count(dest);
        try {
            ActionLib.parse(action, countingDest, lang, base);
            UploadDetails details = new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
            action.log.info(String.format("[%d] Body: Content-Length=%d, Content-Type=%s, Charset=%s => %s : %s", action.id, len, ct.getContentTypeStr(), ct.getCharset(), lang.getName(), details.detailsStr()));
            return details;
        }
        catch (RiotParseException ex) {
            action.log.info(String.format("[%d] Attempt to load: Content-Length=%d, Content-Type=%s, Charset=%s => %s", action.id, len, ct.getContentTypeStr(), ct.getCharset(), ex.getMessage()));
            ActionLib.consumeBody(action);
            throw ex;
        }
    }

    private static UploadDetails multipartCommonsFileUpload(HttpAction action, StreamRDF dest) {
        String base = ActionLib.wholeRequestURL(action.getRequest());
        StreamRDFCounting countingDest = StreamRDFLib.count(dest);
        JakartaServletFileUpload upload = new JakartaServletFileUpload();
        try {
            FileItemInputIterator iter = upload.getItemIterator(action.getRequest());
            while (iter.hasNext()) {
                FileItemInput part = iter.next();
                if (part.isFormField()) {
                    String fieldName = part.getFieldName();
                    InputStream stream = part.getInputStream();
                    String value = IO.readWholeFileAsUTF8(stream);
                    ServletOps.errorBadRequest(String.format("Only files accepted in multipart file upload (got %s=%s)", fieldName, value));
                    return null;
                }
                InputStream input = part.getInputStream();
                String contentTypeHeader = part.getContentType();
                ContentType ct = ContentType.create(contentTypeHeader);
                String fieldName = part.getFieldName();
                String submittedFileName = part.getName();
                DataUploader.handlePart(action, input, base, ct, submittedFileName, countingDest);
            }
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ServletOps.errorOccurred(ex.getMessage());
        }
        UploadDetails details = new UploadDetails(countingDest.count(), countingDest.countTriples(), countingDest.countQuads());
        return details;
    }

    private static void handlePart(HttpAction action, InputStream input, String base, ContentType ct, String submittedFileName, StreamRDF dest) throws IOException {
        String printfilename;
        Lang lang = null;
        if (!WebContent.matchContentType(WebContent.ctTextPlain, ct)) {
            lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
        }
        if (lang == null) {
            if (submittedFileName == null || submittedFileName.equals("")) {
                ServletOps.errorBadRequest("No name for content - can't determine RDF syntax");
            }
            lang = RDFLanguages.pathnameToLang(submittedFileName);
            if (submittedFileName.endsWith(".gz")) {
                input = new GZIPInputStream(input);
            } else if (submittedFileName.endsWith(".bz2")) {
                input = new BZip2CompressorInputStream(input, true);
            }
        }
        if (lang == null) {
            lang = RDFLanguages.RDFXML;
        }
        if ((printfilename = submittedFileName) == null || printfilename.equals("")) {
            printfilename = "<none>";
        }
        StreamRDFCounting countingDest2 = StreamRDFLib.count(dest);
        try {
            ActionLib.parse(action, countingDest2, input, lang, base);
            UploadDetails details1 = new UploadDetails(countingDest2.count(), countingDest2.countTriples(), countingDest2.countQuads());
            action.log.info(String.format("[%d] Filename: %s, Content-Type=%s, Charset=%s => %s : %s", action.id, printfilename, ct.getContentTypeStr(), ct.getCharset(), lang.getName(), details1.detailsStr()));
        }
        catch (RiotParseException ex) {
            action.log.info(String.format("[%d] Filename: %s, Content-Type=%s, Charset=%s => %s : %s", action.id, printfilename, ct.getContentTypeStr(), ct.getCharset(), lang.getName(), ex.getMessage()));
            ActionLib.consumeBody(action);
            throw ex;
        }
    }
}

