/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.LogCtlLog4j2;
import org.apache.jena.fuseki.Fuseki;

public class FusekiLogging {
    private static final String[] resourcesForLog4jProperties = new String[]{"log4j2-test.properties", "log4j2.properties", "log4j2-test.xml", "log4j2.xml"};
    public static String envLogLoggingProperty = "FUSEKI_LOGLOGGING";
    public static String logLoggingProperty = "fuseki.logLogging";
    private static String logLoggingPropertyAlt = "fuseki.loglogging";
    private static boolean logLogging = false;
    private static boolean loggingInitialized = false;
    public static final String log4j2_configurationFile = "log4j2.configurationFile";
    private static final String log4j2_configurationFileLegacy = "log4j.configurationFile";
    public static final String log4j2_web_configuration = "log4jConfiguration";

    private static final boolean getLogLogging() {
        String x = System.getProperty(logLoggingPropertyAlt);
        if (x != null) {
            FusekiLogging.logLogging("Old system property used '%s'", logLoggingPropertyAlt);
            return x.equalsIgnoreCase("true");
        }
        x = Lib.getenv(logLoggingProperty, envLogLoggingProperty);
        return x != null && x.equalsIgnoreCase("true");
    }

    public static synchronized void markInitialized(boolean isInitialized) {
        FusekiLogging.logLogging("markInitialized(" + isInitialized + ")", new Object[0]);
        loggingInitialized = isInitialized;
    }

    public static synchronized void setLogging() {
        FusekiLogging.setLogging(false);
    }

    public static synchronized void setLogging(boolean logLoggingSetup) {
        FusekiLogging.setLogging(null, logLoggingSetup);
    }

    public static synchronized boolean hasInitialized() {
        return loggingInitialized;
    }

    public static synchronized void setLogging(Path extraDir, boolean logLoggingSetup) {
        if (loggingInitialized) {
            return;
        }
        loggingInitialized = true;
        logLogging = logLoggingSetup ? true : FusekiLogging.getLogLogging();
        FusekiLogging.logLogging("Set logging", new Object[0]);
        if (FusekiLogging.checkSystemProperties(log4j2_configurationFile) || FusekiLogging.checkSystemProperties(log4j2_configurationFileLegacy) || System.getenv("LOG4J_CONFIGURATION_FILE") != null) {
            FusekiLogging.logLogging("External log4j2 setup ", new Object[0]);
            return;
        }
        FusekiLogging.logLogging("Setup", new Object[0]);
        String fn1 = "log4j2.properties";
        String fn2 = null;
        if (extraDir != null) {
            fn2 = extraDir.resolve("log4j2.properties").toString();
        }
        if (FusekiLogging.attempt(fn1)) {
            return;
        }
        if (FusekiLogging.attempt(fn2)) {
            return;
        }
        for (String resourceName : resourcesForLog4jProperties) {
            FusekiLogging.logLogging("Try classpath %s", resourceName);
            URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
            if (url == null) continue;
            try (InputStream inputStream = url.openStream();){
                FusekiLogging.loadConfiguration(inputStream, resourceName);
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
            FusekiLogging.logLogging("Found via classpath %s", url);
            System.setProperty(log4j2_configurationFile, url.toString());
            return;
        }
        FusekiLogging.logLogging("Fallback built-in log4j2setup", new Object[0]);
        String dftLog4j = FusekiLogging.log4j2setupFallback();
        FusekiLogging.resetLogging(dftLog4j);
        System.setProperty(log4j2_configurationFile, "set");
    }

    private static boolean checkSystemProperties(String ... properties) {
        String x = null;
        for (String propertyName : properties) {
            x = System.getProperty(propertyName, null);
            if (x == null) continue;
            if ("set".equals(x)) {
                Fuseki.serverLog.warn("Fuseki logging: Unexpected: Log4j2 was setup by some other part of Jena");
                return true;
            }
            return true;
        }
        return false;
    }

    private static void loadConfiguration(InputStream inputStream, String resourceName) throws IOException {
        LogCtlLog4j2.resetLogging(inputStream, resourceName);
    }

    private static boolean attempt(String fn) {
        block10: {
            if (fn == null) {
                return false;
            }
            try {
                FusekiLogging.logLogging("Try file:" + fn, new Object[0]);
                File f = new File(fn);
                if (!f.exists()) break block10;
                FusekiLogging.logLogging("Found via file " + fn, new Object[0]);
                try (FileInputStream input = new FileInputStream(fn);){
                    FusekiLogging.loadConfiguration(input, fn);
                }
                catch (IOException ex) {
                    IO.exception(ex);
                }
                System.setProperty(log4j2_configurationFile, "file:" + fn);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static void logLogging(String fmt, Object ... args) {
        if (logLogging) {
            System.err.print("Fuseki Logging: ");
            System.err.printf(fmt, args);
            System.err.println();
        }
    }

    private static String log4j2setupFallback() {
        return " ## Plain output to stdout\n status = error\n name = FusekiLogging\n appender.console.type = Console\n appender.console.name = OUT\n appender.console.target = SYSTEM_OUT\n appender.console.layout.type = PatternLayout\n ##appender.console.layout.pattern = %d{HH:mm:ss} %-5p %-15c{1} :: %m%n\n appender.console.layout.pattern = [%d{yyyy-MM-dd HH:mm:ss}] %-10c{1} %-5p %m%n\n\n rootLogger.level                  = WARN\n rootLogger.appenderRef.stdout.ref = OUT\n\n logger.jena.name  = org.apache.jena\n logger.jena.level = INFO\n\n logger.arq-exec.name  = org.apache.jena.arq.exec\n logger.arq-exec.level = INFO\n\n logger.riot.name  = org.apache.jena.riot\n logger.riot.level = INFO\n\n logger.fuseki.name  = org.apache.jena.fuseki\n logger.fuseki.level = INFO\n\n logger.fuseki-fuseki.name  = org.apache.jena.fuseki.Fuseki\n logger.fuseki-fuseki.level = INFO\n\n logger.fuseki-server.name  = org.apache.jena.fuseki.Server\n logger.fuseki-server.level = INFO\n\n logger.fuseki-config.name  = org.apache.jena.fuseki.Config\n logger.fuseki-config.level = INFO\n\n logger.fuseki-admin.name  = org.apache.jena.fuseki.Admin\n logger.fuseki-admin.level = INFO\n\n logger.jetty.name  = org.eclipse.jetty\n logger.jetty.level = WARN\n\n logger.shiro.name = org.apache.shiro\n logger.shiro.level = WARN\n\n # Hide issue with Shiro 1.5.0+, 2.0.0\n logger.shiro-realm.name = org.apache.shiro.realm.text.IniRealm\n logger.shiro-realm.level = ERROR\n\n ## (NCSA) Common Log Format request log\n # This goes out in NCSA format\n appender.plain.type = Console\n appender.plain.name = PLAIN\n appender.plain.layout.type = PatternLayout\n appender.plain.layout.pattern = %m%n\n\n logger.fuseki-request.name                   = org.apache.jena.fuseki.Request\n logger.fuseki-request.additivity             = false\n logger.fuseki-request.level                  = OFF\n logger.fuseki-request.appenderRef.plain.ref  = PLAIN\n";
    }

    public static void resetLogging(String configString) {
        LogCtlLog4j2.resetLogging(configString);
    }
}

