/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system;

import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;

public class UploadDetails {
    private final long count;
    private final long tripleCount;
    private final long quadCount;
    private PreState state = PreState.UNKNOWN;
    public static String jCount = "count";
    public static String jTriplesCount = "tripleCount";
    public static String jQuadsCount = "quadCount";

    UploadDetails(long parserCount, long parserTripleCount, long parserQuadCount) {
        this.count = parserCount;
        this.tripleCount = parserTripleCount;
        this.quadCount = parserQuadCount;
    }

    public static String detailsStr(long count, long tripleCount, long quadCount) {
        return String.format("Count=%d Triples=%d Quads=%d", count, tripleCount, quadCount);
    }

    public String detailsStr() {
        return UploadDetails.detailsStr(this.count, this.tripleCount, this.quadCount);
    }

    public static JsonValue detailsJson(long count, long tripleCount, long quadCount) {
        JsonBuilder b = new JsonBuilder();
        b.startObject("details");
        b.key(jCount).value(count);
        b.key(jTriplesCount).value(tripleCount);
        b.key(jQuadsCount).value(quadCount);
        b.finishObject("details");
        return b.build();
    }

    public JsonValue detailsJson() {
        return UploadDetails.detailsJson(this.count, this.tripleCount, this.quadCount);
    }

    public long getCount() {
        return this.count;
    }

    public long getTripleCount() {
        return this.tripleCount;
    }

    public long getQuadCount() {
        return this.quadCount;
    }

    public void setExistedBefore(boolean existedBefore) {
        if (existedBefore) {
            this.setExistedBefore(PreState.EXISTED);
        } else {
            this.setExistedBefore(PreState.ABSENT);
        }
    }

    public void setExistedBefore(PreState state) {
        this.state = state;
    }

    public PreState getExistedBefore() {
        return this.state;
    }

    public static enum PreState {
        EXISTED,
        ABSENT,
        UNKNOWN;

    }
}

