/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.IRIx;

public class IRIProviderJDK
implements IRIProvider {
    private static <X> X exec(Supplier<X> action) {
        try {
            return action.get();
        }
        catch (Throwable ex) {
            throw new IRIException(ex.getMessage());
        }
    }

    @Override
    public IRIx create(String iri2) throws IRIException {
        try {
            URI uri = new URI(iri2);
            return new IRIxJDK(iri2, uri);
        }
        catch (URISyntaxException ex) {
            throw new IRIException(ex.getMessage());
        }
    }

    @Override
    public void check(String iriStr) throws IRIException {
        this.create(iriStr);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void strictMode(String scheme, boolean runStrict) {
    }

    @Override
    public boolean isStrictMode(String scheme) {
        return false;
    }

    static class IRIxJDK
    extends IRIx {
        private final URI javaURI;

        private IRIxJDK(String iriStr, URI iri2) {
            super(iri2.toString());
            this.javaURI = iri2;
        }

        @Override
        public boolean isAbsolute() {
            return this.javaURI.isAbsolute();
        }

        @Override
        public boolean isRelative() {
            return this.javaURI.getScheme() == null;
        }

        @Override
        public boolean isReference() {
            if (this.javaURI.isOpaque()) {
                return true;
            }
            return this.javaURI.getScheme() != null;
        }

        @Override
        public boolean hasScheme(String scheme) {
            String iriScheme = this.scheme();
            if (iriScheme == null) {
                return false;
            }
            return iriScheme.equalsIgnoreCase(scheme);
        }

        @Override
        public String scheme() {
            return this.javaURI.getScheme();
        }

        @Override
        public IRIx resolve(String other) {
            return IRIProviderJDK.exec(() -> {
                URI iriOther = URI.create(other);
                URI iri2 = this.javaURI.resolve(iriOther);
                return new IRIxJDK(iri2.toString(), iri2);
            });
        }

        @Override
        public IRIx resolve(IRIx other) {
            return IRIProviderJDK.exec(() -> {
                IRIxJDK iriOther = (IRIxJDK)other;
                URI iri2 = this.javaURI.resolve(iriOther.javaURI);
                return new IRIxJDK(iri2.toString(), iri2);
            });
        }

        @Override
        public IRIx normalize() {
            URI uri = this.javaURI.normalize();
            return new IRIxJDK(uri.toString(), uri);
        }

        @Override
        public IRIx relativize(IRIx other) {
            return IRIProviderJDK.exec(() -> {
                IRIxJDK iriOther = (IRIxJDK)other;
                URI iri2 = this.javaURI.relativize(iriOther.javaURI);
                return new IRIxJDK(iri2.toString(), iri2);
            });
        }

        @Override
        public URI getImpl() {
            return this.javaURI;
        }

        @Override
        public boolean hasViolations() {
            return false;
        }

        @Override
        public void handleViolations(BiConsumer<Boolean, String> handler) {
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.javaURI);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IRIxJDK other = (IRIxJDK)obj;
            return Objects.equals(this.javaURI, other.javaURI);
        }
    }
}

