/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.spliterator;

import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.jena.mem2.spliterator.SparseArraySubSpliterator;

public class SparseArraySpliterator<E>
implements Spliterator<E> {
    private final E[] entries;
    private int pos;
    private final Runnable checkForConcurrentModification;

    public SparseArraySpliterator(E[] entries, int toIndex, Runnable checkForConcurrentModification) {
        this.entries = entries;
        this.pos = toIndex;
        this.checkForConcurrentModification = checkForConcurrentModification;
    }

    public SparseArraySpliterator(E[] entries, Runnable checkForConcurrentModification) {
        this(entries, entries.length, checkForConcurrentModification);
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        this.checkForConcurrentModification.run();
        while (-1 < --this.pos) {
            if (null == this.entries[this.pos]) continue;
            action.accept(this.entries[this.pos]);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        --this.pos;
        while (-1 < this.pos) {
            if (null != this.entries[this.pos]) {
                action.accept(this.entries[this.pos]);
            }
            --this.pos;
        }
        this.checkForConcurrentModification.run();
    }

    @Override
    public Spliterator<E> trySplit() {
        if (this.pos < 2) {
            return null;
        }
        int toIndexOfSubIterator = this.pos;
        this.pos >>>= 1;
        return new SparseArraySubSpliterator<E>(this.entries, this.pos, toIndexOfSubIterator, this.checkForConcurrentModification);
    }

    @Override
    public long estimateSize() {
        return this.pos;
    }

    @Override
    public int characteristics() {
        return 1281;
    }
}

