/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.cmd;

import arq.cmdline.CmdARQ;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.LogCtlJUL;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextIndexLucene;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class textindexdump
extends CmdARQ {
    private static Logger log = LoggerFactory.getLogger(textindexdump.class);
    public static final ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", "dataset");
    protected TextIndex textIndex = null;

    public static void main(String ... argv) {
        LogCtlJUL.routeJULtoSLF4J();
        new textindexdump(argv).mainRun();
    }

    protected textindexdump(String[] argv) {
        super(argv);
        super.add(assemblerDescDecl, "--desc=", "Assembler description file");
    }

    @Override
    protected void processModulesAndArgs() {
        String file;
        super.processModulesAndArgs();
        if (super.contains(assemblerDescDecl)) {
            if (this.getValues(assemblerDescDecl).size() != 1) {
                throw new CmdException("Multiple assembler descriptions given");
            }
            if (this.getPositional().size() != 0) {
                throw new CmdException("Additional assembler descriptions given");
            }
            file = this.getValue(assemblerDescDecl);
        } else {
            if (this.getNumPositional() != 1) {
                throw new CmdException("Multiple assembler descriptions given");
            }
            file = this.getPositionalArg(0);
        }
        this.textIndex = (TextIndex)AssemblerUtils.build(file, TextVocab.textIndex);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " assemblerFile";
    }

    @Override
    protected void exec() {
        if (this.textIndex instanceof TextIndexLucene) {
            textindexdump.dump((TextIndexLucene)this.textIndex);
        } else {
            System.err.println("Unsupported index type : " + Lib.className(this.textIndex));
        }
    }

    private static void dump(TextIndexLucene textIndex) {
        try {
            Directory directory = textIndex.getDirectory();
            Analyzer analyzer = textIndex.getQueryAnalyzer();
            DirectoryReader indexReader = DirectoryReader.open(directory);
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            QueryParser queryParser = new QueryParser(textIndex.getDocDef().getPrimaryField(), analyzer);
            Query query2 = queryParser.parse("*:*");
            ScoreDoc[] sDocs = indexSearcher.search((Query)query2, (int)1000).scoreDocs;
            StoredFields sFields = indexSearcher.storedFields();
            for (ScoreDoc sd : sDocs) {
                System.out.println("Doc: " + sd.doc);
                Document doc = sFields.document(sd.doc);
                for (IndexableField f : doc) {
                    System.out.println("  " + f.name() + " = " + f.stringValue());
                }
            }
        }
        catch (Exception ex) {
            throw new TextIndexException(ex);
        }
    }
}

