/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.ReasonerFactory;
import org.apache.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import org.apache.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import org.apache.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import org.apache.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import org.apache.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import org.apache.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.ReasonerVocabulary;

public class ReasonerRegistry {
    protected static ReasonerRegistry theRegistry;
    protected Map<String, ReasonerFactory> reasonerFactories = new HashMap<String, ReasonerFactory>();
    protected Model allDescriptions = ModelFactory.createDefaultModel();
    protected static Reasoner theRDFSReasoner;
    protected static Reasoner theRDFSSimpleReasoner;
    protected static Reasoner theTRANSITIVEReasoner;
    protected static Reasoner theOWLReasoner;
    protected static Reasoner theOWLMicroReasoner;
    protected static Reasoner theOWLMiniReasoner;

    private ReasonerRegistry() {
        this.register(TransitiveReasonerFactory.theInstance());
        this.register(RDFSRuleReasonerFactory.theInstance());
        this.register(OWLFBRuleReasonerFactory.theInstance());
        this.register(GenericRuleReasonerFactory.theInstance());
        this.register(OWLMicroReasonerFactory.theInstance());
        this.register(OWLMiniReasonerFactory.theInstance());
    }

    public static ReasonerRegistry theRegistry() {
        if (theRegistry == null) {
            theRegistry = new ReasonerRegistry();
        }
        return theRegistry;
    }

    public void register(ReasonerFactory factory) {
        this.reasonerFactories.put(factory.getURI(), factory);
        Model description = factory.getCapabilities();
        if (description != null) {
            this.allDescriptions.add(description);
        }
        this.allDescriptions.createResource(factory.getURI()).addProperty(RDF.type, ReasonerVocabulary.ReasonerClass);
    }

    public void register(String reasonerUri, ReasonerFactory factory) {
        this.reasonerFactories.put(reasonerUri, factory);
        this.allDescriptions.createResource(reasonerUri).addProperty(RDF.type, ReasonerVocabulary.ReasonerClass);
    }

    public Model getAllDescriptions() {
        return this.allDescriptions;
    }

    public Resource getDescription(String uri) {
        Resource reasonerURI = this.allDescriptions.getResource(uri);
        if (this.allDescriptions.contains(reasonerURI, RDF.type, ReasonerVocabulary.ReasonerClass)) {
            return reasonerURI;
        }
        return null;
    }

    public ReasonerFactory getFactory(String uri) {
        return this.reasonerFactories.get(uri);
    }

    public Reasoner create(String uri, Resource configuration) throws ReasonerException {
        ReasonerFactory factory = this.getFactory(uri);
        if (factory != null) {
            return factory.create(configuration);
        }
        throw new ReasonerException("Attempted to instantiate an unknown reasoner: " + uri);
    }

    public static Node makeDirect(Node node) {
        return NodeFactory.createURI(ReasonerRegistry.makeDirect(node.getURI()));
    }

    public static String makeDirect(String uri) {
        return "urn:x-hp-direct-predicate:" + uri.replace(':', '_');
    }

    public static Reasoner getRDFSReasoner() {
        if (theRDFSReasoner == null) {
            theRDFSReasoner = RDFSRuleReasonerFactory.theInstance().create(null);
        }
        return theRDFSReasoner;
    }

    public static Reasoner getRDFSSimpleReasoner() {
        if (theRDFSSimpleReasoner == null) {
            theRDFSSimpleReasoner = RDFSRuleReasonerFactory.theInstance().create(null);
            theRDFSSimpleReasoner.setParameter(ReasonerVocabulary.PROPsetRDFSLevel, "simple");
        }
        return theRDFSSimpleReasoner;
    }

    public static Reasoner getTransitiveReasoner() {
        if (theTRANSITIVEReasoner == null) {
            theTRANSITIVEReasoner = TransitiveReasonerFactory.theInstance().create(null);
        }
        return theTRANSITIVEReasoner;
    }

    public static Reasoner getOWLReasoner() {
        if (theOWLReasoner == null) {
            theOWLReasoner = OWLFBRuleReasonerFactory.theInstance().create(null);
        }
        return theOWLReasoner;
    }

    public static Reasoner getOWLMicroReasoner() {
        if (theOWLMicroReasoner == null) {
            theOWLMicroReasoner = OWLMicroReasonerFactory.theInstance().create(null);
        }
        return theOWLMicroReasoner;
    }

    public static Reasoner getOWLMiniReasoner() {
        if (theOWLMiniReasoner == null) {
            theOWLMiniReasoner = OWLMiniReasonerFactory.theInstance().create(null);
        }
        return theOWLMiniReasoner;
    }

    static {
        theRDFSReasoner = null;
        theRDFSSimpleReasoner = null;
    }
}

