/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.jena.rfc3986.Issue;
import org.apache.jena.rfc3986.Severity;

public class SeverityMap {
    private final String severityMapName;
    private final Map<Issue, Severity> map;

    public static SeverityMap create(String name, Map<Issue, Severity> map) {
        SeverityMap.checkSeverityMappingComplete(name, map);
        return new SeverityMap(name, map);
    }

    private SeverityMap(String name, Map<Issue, Severity> map) {
        this.map = Map.copyOf(map);
        this.severityMapName = name;
    }

    public Map<Issue, Severity> asMap() {
        return new ConcurrentHashMap<Issue, Severity>(this.map);
    }

    public Severity get(Issue issue) {
        return this.map.get((Object)issue);
    }

    public Severity getOrDefault(Issue issue, Severity dftSeverity) {
        return this.map.getOrDefault((Object)issue, dftSeverity);
    }

    public void forEach(BiConsumer<Issue, Severity> action) {
        this.map.forEach(action);
    }

    public String toString() {
        return "SeverityMap: " + this.severityMapName;
    }

    public static void setSeverity(Map<Issue, Severity> map, Issue issue, Severity severity) {
        Objects.requireNonNull(issue);
        Objects.requireNonNull(severity);
        map.put(issue, severity);
    }

    static void checkSeverityMappingComplete(String name, Map<Issue, Severity> levels) {
        Set<Issue> keys = levels.keySet();
        for (Issue issue : Issue.values()) {
            if (keys.contains((Object)issue)) continue;
            System.err.printf("Severity map %s : Missing entry for issue %s\n", new Object[]{name, issue});
        }
        if (levels.get((Object)Issue.ParseError) != Severity.INVALID) {
            System.err.printf("Severity map %s : %s is not severity INVALID", new Object[]{name, Issue.ParseError});
        }
    }
}

