/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.atlas.lib.InternalErrorException;

public class Cardinality {
    public static final int UNSET = -3;
    public static final int UNBOUNDED = -2;
    public final String image;
    public final int min;
    public final int max;
    private static Pattern repeatRange = Pattern.compile(".(\\d+)(,(\\d+|\\*)?)?.");

    public Cardinality(String image, int min2, int max2) {
        this.image = image;
        this.min = min2;
        this.max = max2;
    }

    public static Cardinality create(String image) {
        int min2 = -1;
        int max2 = -1;
        switch (image) {
            case "*": {
                min2 = 0;
                max2 = -2;
                break;
            }
            case "?": {
                min2 = 0;
                max2 = 1;
                break;
            }
            case "+": {
                min2 = 1;
                max2 = -2;
                break;
            }
            default: {
                Matcher matcher = repeatRange.matcher(image);
                if (!matcher.matches()) {
                    throw new InternalErrorException("ShExC: Unexpected cardinality: '" + image + "'");
                }
                min2 = Cardinality.integerRange(matcher.group(1), -3);
                if (matcher.groupCount() != 3) {
                    throw new InternalErrorException("ShExC: Unexpected cardinality: '" + image + "'");
                }
                String comma = matcher.group(2);
                max2 = comma == null ? min2 : Cardinality.integerRange(matcher.group(3), -2);
            }
        }
        return new Cardinality(image, min2, max2);
    }

    private static int integerRange(String str2, int dftValue) {
        if (str2 == null) {
            return dftValue;
        }
        if (str2.equals("*")) {
            return -2;
        }
        try {
            return Integer.parseInt(str2);
        }
        catch (NumberFormatException ex) {
            throw new InternalErrorException("Number format exception");
        }
    }

    static String cardStr(int min2, int max2) {
        if (min2 == -3 && max2 == -3) {
            return "";
        }
        if (min2 == 0 && max2 == -2) {
            return "*";
        }
        if (min2 == 1 && max2 == -2) {
            return "+";
        }
        if (min2 == 0 && max2 == 1) {
            return "?";
        }
        if (max2 == min2) {
            return "{" + min2 + "}";
        }
        if (max2 == -2) {
            return "{" + min2 + ",}";
        }
        return "{" + min2 + "," + max2 + "}";
    }

    public String toString() {
        return Cardinality.cardStr(this.min, this.max);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cardinality other = (Cardinality)obj;
        return Objects.equals(this.image, other.image) && this.max == other.max && this.min == other.min;
    }
}

