/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.TransformWrapper;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.walker.ApplyTransformVisitor;
import org.apache.jena.sparql.algebra.walker.Walker;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;

public class Transformer {
    private static Transformer singleton = new Transformer();

    public static Transformer get() {
        return singleton;
    }

    public static void set(Transformer value) {
        singleton = value;
    }

    public static Op transform(Transform transform, Op op) {
        return Transformer.get().transformation(transform, op, null, null);
    }

    public static Op transform(Transform transform, ExprTransform exprTransform, Op op) {
        return Transformer.get().transformation(transform, exprTransform, op, null, null);
    }

    public static Op transform(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return Transformer.get().transformation(transform, op, beforeVisitor, afterVisitor);
    }

    public static Op transform(Transform transform, ExprTransform exprTransform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return Transformer.get().transformation(transform, exprTransform, op, beforeVisitor, afterVisitor);
    }

    public static Op transformSkipService(Transform transform, Op op) {
        return Transformer.transformSkipService(transform, null, op, null, null);
    }

    public static Op transformSkipService(Transform transform, ExprTransform exprTransform, Op op) {
        return Transformer.transformSkipService(transform, exprTransform, op, null, null);
    }

    public static Op transformSkipService(Transform opTransform, ExprTransform exprTransform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (opTransform == null) {
            opTransform = new TransformCopy();
        }
        if (exprTransform == null) {
            exprTransform = new ExprTransformCopy();
        }
        Transform transform2 = new TransformSkipService(opTransform);
        transform2 = opTransform;
        ApplyTransformVisitor atv = new ApplyTransformVisitor(transform2, exprTransform, false, beforeVisitor, afterVisitor);
        return Walker.transformSkipService(op, atv, beforeVisitor, afterVisitor);
    }

    protected Op transformation(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return this.transformation(transform, null, op, beforeVisitor, afterVisitor);
    }

    protected Op transformation(Transform transform, ExprTransform exprTransform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return this.transformation$(transform, exprTransform, op, beforeVisitor, afterVisitor);
    }

    private Op transformation$(Transform transform, ExprTransform exprTransform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return Walker.transform(op, transform, exprTransform, beforeVisitor, afterVisitor);
    }

    static class TransformSkipService
    extends TransformWrapper {
        public TransformSkipService(Transform transform) {
            super(transform);
        }

        @Override
        public Op transform(OpService opService, Op subOp) {
            return opService;
        }
    }
}

