/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.Quad;

public abstract class DatasetGraphTriplesQuads
extends DatasetGraphBaseFind {
    @Override
    public final void add(Quad quad) {
        this.add(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public final void delete(Quad quad) {
        this.delete(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public final void add(Node g, Node s, Node p, Node o) {
        if (Quad.isUnionGraph(g)) {
            throw new AddDeniedException("Can't add to the union graph");
        }
        if (g == null || Quad.isDefaultGraph(g)) {
            this.addToDftGraph(s, p, o);
        } else {
            this.addToNamedGraph(g, s, p, o);
        }
    }

    @Override
    public final void delete(Node g, Node s, Node p, Node o) {
        if (Quad.isUnionGraph(g)) {
            throw new DeleteDeniedException("Can't remove from the union graph");
        }
        if (g == null || Quad.isDefaultGraph(g)) {
            this.deleteFromDftGraph(s, p, o);
        } else {
            this.deleteFromNamedGraph(g, s, p, o);
        }
    }

    protected abstract void addToDftGraph(Node var1, Node var2, Node var3);

    protected abstract void addToNamedGraph(Node var1, Node var2, Node var3, Node var4);

    protected abstract void deleteFromDftGraph(Node var1, Node var2, Node var3);

    protected abstract void deleteFromNamedGraph(Node var1, Node var2, Node var3, Node var4);

    @Override
    public void addGraph(Node graphName, Graph graph) {
        GraphUtil.addInto(this.getGraph(graphName), graph);
    }

    @Override
    public void removeGraph(Node graphName) {
        this.deleteAny(graphName, Node.ANY, Node.ANY, Node.ANY);
    }
}

