/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.shared.Lock;
import org.apache.jena.shared.LockMRPlusSW;
import org.apache.jena.shared.LockMRSW;
import org.apache.jena.shared.LockMutex;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;

public class TransactionalLock
implements Transactional {
    private ThreadLocal<Boolean> inTransaction = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private ThreadLocal<TxnType> txnType = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<ReadWrite> txnMode = ThreadLocal.withInitial(() -> null);
    private final Lock lock;

    public static TransactionalLock create(Lock lock) {
        return new TransactionalLock(lock);
    }

    public static TransactionalLock createMRPlusSW() {
        return TransactionalLock.create(new LockMRPlusSW());
    }

    public static TransactionalLock createMRSW() {
        return TransactionalLock.create(new LockMRSW());
    }

    public static TransactionalLock createMutex() {
        return TransactionalLock.create(new LockMutex());
    }

    protected TransactionalLock(Lock lock) {
        this.lock = lock;
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.begin(TxnType.convert(readWrite));
    }

    @Override
    public void begin(TxnType txnType) {
        if (this.isInTransaction()) {
            this.error("Already in a transaction");
        }
        switch (txnType) {
            case READ_PROMOTE: 
            case READ_COMMITTED_PROMOTE: {
                throw new UnsupportedOperationException("begin(TxnType." + String.valueOf((Object)txnType) + ")");
            }
        }
        ReadWrite readWrite = TxnType.convert(txnType);
        boolean isRead = readWrite.equals((Object)ReadWrite.READ);
        this.lock.enterCriticalSection(isRead);
        this.inTransaction.set(true);
        this.txnMode.set(readWrite);
        this.txnType.set(txnType);
    }

    @Override
    public ReadWrite transactionMode() {
        return Lib.readThreadLocal(this.txnMode);
    }

    @Override
    public TxnType transactionType() {
        return Lib.readThreadLocal(this.txnType);
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        return false;
    }

    @Override
    public void commit() {
        this.endOnce();
    }

    @Override
    public void abort() {
        this.endOnce();
    }

    @Override
    public boolean isInTransaction() {
        return this.inTransaction.get();
    }

    public boolean isTransactionMode(ReadWrite mode) {
        if (!this.isInTransaction()) {
            return false;
        }
        return Lib.readThreadLocal(this.txnMode) == mode;
    }

    @Override
    public void end() {
        if (this.isTransactionMode(ReadWrite.WRITE)) {
            this.error("Write transaction - no commit or abort before end()");
        }
        this.endOnce();
    }

    protected void endOnce() {
        if (this.isInTransaction()) {
            this.lock.leaveCriticalSection();
            this.txnMode.set(null);
            this.txnType.set(null);
            this.inTransaction.set(false);
            this.txnMode.remove();
            this.txnType.remove();
            this.inTransaction.remove();
        }
    }

    protected void error(String msg) {
        throw new JenaTransactionException(msg);
    }
}

