/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.scripting.ScriptDenyException;

public class VarExprList {
    private List<Var> vars;
    private LinkedHashMap<Var, Expr> exprs;

    public VarExprList(VarExprList other) {
        this.vars = new ArrayList<Var>(other.vars);
        this.exprs = new LinkedHashMap<Var, Expr>(other.exprs);
    }

    public VarExprList() {
        this.vars = new ArrayList<Var>();
        this.exprs = new LinkedHashMap();
    }

    public VarExprList(Var var, Expr expr) {
        this();
        this.add(var, expr);
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public Map<Var, Expr> getExprs() {
        return this.exprs;
    }

    public void forEachExpr(BiConsumer<Var, Expr> action) {
        this.exprs.forEach(action);
    }

    public void forEachVarExpr(BiConsumer<Var, Expr> action) {
        this.getVars().forEach(v -> {
            Expr e2 = this.exprs.get(v);
            action.accept((Var)v, e2);
        });
    }

    public void forEachVar(Consumer<Var> action) {
        this.getVars().forEach(v -> action.accept((Var)v));
    }

    public boolean contains(Var var) {
        return this.vars.contains(var);
    }

    public boolean hasExpr(Var var) {
        return this.exprs.containsKey(var);
    }

    public Expr getExpr(Var var) {
        return this.exprs.get(var);
    }

    public Node get(Var var, Binding binding, FunctionEnv funcEnv) {
        Expr expr = this.exprs.get(var);
        if (expr == null) {
            return binding.get(var);
        }
        try {
            NodeValue nv = expr.eval(binding, funcEnv);
            if (nv == null) {
                return null;
            }
            return nv.asNode();
        }
        catch (ScriptDenyException ex) {
            throw ex;
        }
        catch (ExprEvalException ex) {
            return null;
        }
    }

    public void add(Var var) {
        if (var == null) {
            throw new ARQInternalErrorException("Attempt to add a null variable");
        }
        this.vars.add(var);
    }

    public void add(Var var, Expr expr) {
        if (expr == null) {
            this.add(var);
            return;
        }
        if (this.exprs.containsKey(var)) {
            throw new ARQInternalErrorException("Attempt to assign an expression again");
        }
        this.add(var);
        this.exprs.put(var, expr);
    }

    public void addAll(VarExprList other) {
        for (Var v : other.vars) {
            Expr e2 = other.getExpr(v);
            this.add(v, e2);
        }
    }

    public void remove(Var var) {
        this.vars.remove(var);
        this.exprs.remove(var);
    }

    public void update(Var var, Expr newExpr) {
        this.exprs.put(var, newExpr);
        if (!this.vars.contains(var)) {
            this.vars.add(var);
        }
    }

    public void clear() {
        this.vars.clear();
        this.exprs.clear();
    }

    public int size() {
        return this.vars.size();
    }

    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    public int hashCode() {
        int x = this.vars.hashCode() ^ this.exprs.hashCode();
        return x;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VarExprList)) {
            return false;
        }
        VarExprList varExprList = (VarExprList)other;
        return Objects.equals(this.vars, varExprList.vars) && Objects.equals(this.exprs, varExprList.exprs);
    }

    public String toString() {
        return this.vars.toString() + " // " + this.exprs.toString();
    }
}

