/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.util.List;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase0;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Symbol;

public class SystemVar
extends FunctionBase0 {
    private Symbol systemSymbol;

    protected SystemVar(Symbol systemSymbol) {
        if (systemSymbol == null) {
            throw new ExprException("System symbol is null ptr");
        }
        this.systemSymbol = systemSymbol;
    }

    @Override
    public NodeValue exec() {
        throw new InternalErrorException("SystemVar.exec should not have been called");
    }

    @Override
    public NodeValue exec(List<NodeValue> args, FunctionEnv env) {
        return SystemVar.get(this.systemSymbol, env);
    }

    public static NodeValue get(Symbol symbol, FunctionEnv env) {
        Object obj = env.getContext().get(symbol);
        if (obj == null) {
            throw new ExprEvalException("null for symbol: " + String.valueOf(symbol));
        }
        if (!(obj instanceof Node)) {
            throw new ExprEvalException("Not a Node: " + Lib.className(obj));
        }
        Node n = (Node)obj;
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }
}

