/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Add;
import org.apache.jena.sparql.expr.E_AdjustToTimezone;
import org.apache.jena.sparql.expr.E_BNode;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Call;
import org.apache.jena.sparql.expr.E_Coalesce;
import org.apache.jena.sparql.expr.E_Datatype;
import org.apache.jena.sparql.expr.E_DateTimeDay;
import org.apache.jena.sparql.expr.E_DateTimeHours;
import org.apache.jena.sparql.expr.E_DateTimeMinutes;
import org.apache.jena.sparql.expr.E_DateTimeMonth;
import org.apache.jena.sparql.expr.E_DateTimeSeconds;
import org.apache.jena.sparql.expr.E_DateTimeTZ;
import org.apache.jena.sparql.expr.E_DateTimeTimezone;
import org.apache.jena.sparql.expr.E_DateTimeYear;
import org.apache.jena.sparql.expr.E_Divide;
import org.apache.jena.sparql.expr.E_EBV;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_GreaterThan;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_HasLang;
import org.apache.jena.sparql.expr.E_HasLangDir;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.E_IRI2;
import org.apache.jena.sparql.expr.E_If;
import org.apache.jena.sparql.expr.E_IsBlank;
import org.apache.jena.sparql.expr.E_IsIRI;
import org.apache.jena.sparql.expr.E_IsLiteral;
import org.apache.jena.sparql.expr.E_IsNumeric;
import org.apache.jena.sparql.expr.E_IsTriple;
import org.apache.jena.sparql.expr.E_IsURI;
import org.apache.jena.sparql.expr.E_Lang;
import org.apache.jena.sparql.expr.E_LangDir;
import org.apache.jena.sparql.expr.E_LangMatches;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.E_LessThanOrEqual;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_MD5;
import org.apache.jena.sparql.expr.E_Multiply;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.E_Now;
import org.apache.jena.sparql.expr.E_NumAbs;
import org.apache.jena.sparql.expr.E_NumCeiling;
import org.apache.jena.sparql.expr.E_NumFloor;
import org.apache.jena.sparql.expr.E_NumRound;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.E_OpNumericIntegerDivide;
import org.apache.jena.sparql.expr.E_OpNumericMod;
import org.apache.jena.sparql.expr.E_Random;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.E_SHA1;
import org.apache.jena.sparql.expr.E_SHA224;
import org.apache.jena.sparql.expr.E_SHA256;
import org.apache.jena.sparql.expr.E_SHA384;
import org.apache.jena.sparql.expr.E_SHA512;
import org.apache.jena.sparql.expr.E_SameTerm;
import org.apache.jena.sparql.expr.E_SameValue;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.E_StrAfter;
import org.apache.jena.sparql.expr.E_StrBefore;
import org.apache.jena.sparql.expr.E_StrConcat;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.E_StrDatatype;
import org.apache.jena.sparql.expr.E_StrEncodeForURI;
import org.apache.jena.sparql.expr.E_StrEndsWith;
import org.apache.jena.sparql.expr.E_StrLang;
import org.apache.jena.sparql.expr.E_StrLangDir;
import org.apache.jena.sparql.expr.E_StrLength;
import org.apache.jena.sparql.expr.E_StrLowerCase;
import org.apache.jena.sparql.expr.E_StrReplace;
import org.apache.jena.sparql.expr.E_StrStartsWith;
import org.apache.jena.sparql.expr.E_StrSubstring;
import org.apache.jena.sparql.expr.E_StrUUID;
import org.apache.jena.sparql.expr.E_StrUpperCase;
import org.apache.jena.sparql.expr.E_Subtract;
import org.apache.jena.sparql.expr.E_TripleFn;
import org.apache.jena.sparql.expr.E_TripleObject;
import org.apache.jena.sparql.expr.E_TriplePredicate;
import org.apache.jena.sparql.expr.E_TripleSubject;
import org.apache.jena.sparql.expr.E_URI;
import org.apache.jena.sparql.expr.E_URI2;
import org.apache.jena.sparql.expr.E_UUID;
import org.apache.jena.sparql.expr.E_UnaryMinus;
import org.apache.jena.sparql.expr.E_UnaryPlus;
import org.apache.jena.sparql.expr.E_Version;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorFactory;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.builders.BuilderLib;
import org.apache.jena.sparql.sse.builders.BuilderNode;
import org.apache.jena.sparql.sse.builders.BuilderOp;
import org.apache.jena.sparql.util.NodeUtils;

public class BuilderExpr {
    private static final Map<String, Build> dispatch;
    private static Build buildRegex;
    private static Build buildPlus;
    private static Build buildUnaryPlus;
    private static Build buildMinus;
    private static Build buildUnaryMinus;
    private static Build buildEQ;
    private static Build buildNE;
    private static Build buildGT;
    private static Build buildLT;
    private static Build buildLE;
    private static Build buildGE;
    private static Build buildOr;
    private static Build buildAnd;
    private static Build buildNot;
    private static Build buildEBV;
    private static Build buildMult;
    private static Build buildDiv;
    private static Build buildIDiv;
    private static Build buildMod;
    private static Build buildStr;
    private static Build buildStrLang;
    private static Build buildStrLangDir;
    private static Build buildStrDatatype;
    private static Build buildRand;
    private static Build buildYear;
    private static Build buildMonth;
    private static Build buildDay;
    private static Build buildHours;
    private static Build buildMinutes;
    private static Build buildSeconds;
    private static Build buildTimezone;
    private static Build buildTZ;
    private static Build buildAdjust;
    private static Build buildNow;
    private static Build buildUUID;
    private static Build buildStrUUID;
    private static Build buildVersion;
    private static Build buildMD5;
    private static Build buildSHA1;
    private static Build buildSHA224;
    private static Build buildSHA256;
    private static Build buildSHA384;
    private static Build buildSHA512;
    private static Build buildStrlen;
    private static Build buildSubstr;
    private static Build buildStrReplace;
    private static Build buildStrUppercase;
    private static Build buildStrLowercase;
    private static Build buildStrEnds;
    private static Build buildStrStarts;
    private static Build buildStrBefore;
    private static Build buildStrAfter;
    private static Build buildStrContains;
    private static Build buildStrEncode;
    private static Build buildNumAbs;
    private static Build buildNumRound;
    private static Build buildNumCeiling;
    private static Build buildNumFloor;
    private static Build buildLang;
    private static Build buildLangDir;
    private static Build buildLangMatches;
    private static Build buildSameTerm;
    private static Build buildSameValue;
    private static Build buildDatatype;
    private static Build buildBound;
    private static Build buildCoalesce;
    private static Build buildConcat;
    private static Build buildIfExpr;
    private static Build buildIsIRI;
    private static Build buildIsURI;
    private static Build buildIsBlank;
    private static Build buildIsLiteral;
    private static Build buildIsNumeric;
    private static Build buildIsLang;
    private static Build buildIsLangDir;
    private static Build buildExists;
    private static Build buildNotExists;
    private static Build buildBNode;
    private static Build buildIri;
    private static Build buildUri;
    private static Build buildIri2;
    private static Build buildUri2;
    private static Build buildIn;
    private static Build buildNotIn;
    private static Build buildSubject;
    private static Build buildPredicate;
    private static Build buildObject;
    private static Build buildTripleFn;
    private static Build buildIsTriple;
    private static Build buildCall;
    private static Build buildCount;
    private static Build buildSum;
    private static Build buildMin;
    private static Build buildMax;
    private static Build buildAvg;
    private static Build buildSample;
    private static Build buildGroupConcat;
    private static Build buildCustomAggregate;
    private static Build buildAggNull;

    public static ExprList buildExprOrExprList(Item item) {
        if (item.isTagged("exprlist")) {
            return BuilderExpr.buildExprList(item);
        }
        if (BuilderExpr.listOfLists(item)) {
            return BuilderExpr.buildExprListUntagged(item.getList(), 0);
        }
        Expr expr = BuilderExpr.buildExpr(item);
        ExprList exprList = new ExprList(expr);
        return exprList;
    }

    private static boolean listOfLists(Item item) {
        if (!item.isList()) {
            return false;
        }
        return item.getList().car().isList();
    }

    public static ExprList buildExprList(Item item) {
        if (!item.isTagged("exprlist")) {
            BuilderLib.broken(item, "Not tagged exprlist");
        }
        ItemList list = item.getList();
        return BuilderExpr.buildExprListUntagged(list, 1);
    }

    private static ExprList buildExprListUntagged(Item item) {
        return BuilderExpr.buildExprListUntagged(item.getList(), 0);
    }

    private static ExprList buildExprListUntagged(ItemList list, int idx) {
        ExprList exprList = new ExprList();
        for (int i = idx; i < list.size(); ++i) {
            Item item = list.get(i);
            exprList.add(BuilderExpr.buildExpr(item));
        }
        return exprList;
    }

    public static VarExprList buildNamedExprOrExprList(Item item) {
        ItemList list;
        if (!item.isList()) {
            BuilderLib.broken(item, "Not a var expr list");
        }
        if ((list = item.getList()).isEmpty()) {
            return new VarExprList();
        }
        if (list.car().isList()) {
            return BuilderExpr.buildNamedExprList(list);
        }
        return BuilderExpr.buildNamedExpr(item);
    }

    public static VarExprList buildNamedExprList(ItemList list) {
        VarExprList x = new VarExprList();
        for (Item item : list) {
            BuilderExpr.buildNamedExpr(item, x);
        }
        return x;
    }

    public static VarExprList buildNamedExpr(Item item) {
        VarExprList varExprList = new VarExprList();
        BuilderExpr.buildNamedExpr(item, varExprList);
        return varExprList;
    }

    public static boolean isDefined(String tag) {
        return dispatch.containsKey(tag);
    }

    public static Expr buildExpr(ItemList list) {
        Build b;
        Item item;
        String tag;
        if (list.size() == 0) {
            BuilderLib.broken(list, "Empty list for expression");
        }
        if ((tag = (item = list.get(0)).getSymbol()) == null) {
            BuilderLib.broken(item, "Null tag");
        }
        if ((b = BuilderExpr.findBuild(tag)) == null) {
            BuilderLib.broken(item, "No known symbol for " + tag);
        }
        return b.make(list);
    }

    private static void buildNamedExpr(Item item, VarExprList varExprList) {
        ItemList list;
        if (item.isNode()) {
            Var v = BuilderNode.buildVar(item);
            varExprList.add(v);
            return;
        }
        if (!item.isList() || item.getList().size() != 2) {
            BuilderLib.broken(item, "Not a var or var/expression pair");
        }
        if ((list = item.getList()).size() == 1) {
            Var v = BuilderNode.buildVar(list.car());
            varExprList.add(v);
            return;
        }
        if (list.size() != 2) {
            BuilderLib.broken(list, "Not a var or var/expression pair");
        }
        Var var = BuilderNode.buildVar(list.get(0));
        Expr expr = BuilderExpr.buildExpr(list.get(1));
        varExprList.add(var, expr);
    }

    public static Expr buildExpr(Item item) {
        if (item.isNode()) {
            return ExprLib.nodeToExpr(item.getNode());
        }
        Object expr = null;
        if (item.isList()) {
            Item head;
            ItemList list = item.getList();
            if (list.size() == 0) {
                BuilderLib.broken(item, "Empty list for expression");
            }
            if ((head = list.get(0)).isNode()) {
                if (head.getNode().isVariable() && list.size() == 1) {
                    return new ExprVar(Var.alloc(head.getNode()));
                }
                return BuilderExpr.buildFunctionCall(list);
            }
            if (head.isList()) {
                BuilderLib.broken(item, "Head is a list");
            } else if (head.isSymbol()) {
                if (item.isTagged("expr")) {
                    BuilderLib.checkLength(2, list, "Wrong length: " + item.shortString());
                    item = list.get(1);
                    return BuilderExpr.buildExpr(item);
                }
                return BuilderExpr.buildExpr(list);
            }
            throw new ARQInternalErrorException();
        }
        if (item.isSymbolIgnoreCase("true")) {
            return NodeValue.TRUE;
        }
        if (item.isSymbolIgnoreCase("false")) {
            return NodeValue.FALSE;
        }
        BuilderLib.broken(item, "Not a list or a node or recognized symbol: " + String.valueOf(item));
        return null;
    }

    private BuilderExpr() {
    }

    private static int numArgs(ItemList list) {
        return list.size() - 1;
    }

    private static Build findBuild(String str2) {
        return dispatch.get(str2);
    }

    private static Expr buildFunctionCall(ItemList list) {
        Item head = list.get(0);
        Node node = head.getNode();
        if (node.isBlank()) {
            BuilderLib.broken(head, "Blank node for function call!");
        }
        if (node.isLiteral()) {
            BuilderLib.broken(head, "Literal node for function call!");
        }
        ExprList args = BuilderExpr.buildExprListUntagged(list, 1);
        return new E_Function(node.getURI(), args);
    }

    private static String asString(Item item) {
        Node n = item.getNode();
        if (!NodeUtils.isSimpleString(n)) {
            BuilderLib.broken(item, "Need string: " + String.valueOf(item));
        }
        return n.getLiteralLexicalForm();
    }

    private static boolean startsWithDistinct(ItemList x) {
        return x.size() > 0 && x.car().isSymbol("distinct");
    }

    private static Build aggCommonOne(BuildAgg make) {
        return list -> {
            ItemList x = list.cdr();
            boolean distinct = BuilderExpr.startsWithDistinct(x);
            if (distinct) {
                x = x.cdr();
            }
            BuilderLib.checkLength(1, x, "Broken syntax: " + list.shortString());
            Expr expr = BuilderExpr.buildExpr(x.get(0));
            return make.aggExpr(distinct, expr);
        };
    }

    private static Map<String, Build> createDispatchTable() {
        HashMap<String, Build> dispatchMap = new HashMap<String, Build>();
        BuilderExpr.dispatch(dispatchMap, "regex", buildRegex);
        BuilderExpr.dispatch(dispatchMap, "=", buildEQ);
        BuilderExpr.dispatch(dispatchMap, "eq", buildEQ);
        BuilderExpr.dispatch(dispatchMap, "!=", buildNE);
        BuilderExpr.dispatch(dispatchMap, "ne", buildNE);
        BuilderExpr.dispatch(dispatchMap, ">", buildGT);
        BuilderExpr.dispatch(dispatchMap, "gt", buildGT);
        BuilderExpr.dispatch(dispatchMap, "<", buildLT);
        BuilderExpr.dispatch(dispatchMap, "lt", buildLT);
        BuilderExpr.dispatch(dispatchMap, "<=", buildLE);
        BuilderExpr.dispatch(dispatchMap, "le", buildLE);
        BuilderExpr.dispatch(dispatchMap, ">=", buildGE);
        BuilderExpr.dispatch(dispatchMap, "ge", buildGE);
        BuilderExpr.dispatch(dispatchMap, "||", buildOr);
        BuilderExpr.dispatch(dispatchMap, "or", buildOr);
        BuilderExpr.dispatch(dispatchMap, "&&", buildAnd);
        BuilderExpr.dispatch(dispatchMap, "and", buildAnd);
        BuilderExpr.dispatch(dispatchMap, "not", buildNot);
        BuilderExpr.dispatch(dispatchMap, "!", buildNot);
        BuilderExpr.dispatch(dispatchMap, "ebv", buildEBV);
        BuilderExpr.dispatch(dispatchMap, "+", buildPlus);
        BuilderExpr.dispatch(dispatchMap, "add", buildPlus);
        BuilderExpr.dispatch(dispatchMap, "-", buildMinus);
        BuilderExpr.dispatch(dispatchMap, "subtract", buildMinus);
        BuilderExpr.dispatch(dispatchMap, "minus", buildMinus);
        BuilderExpr.dispatch(dispatchMap, "unaryplus", buildUnaryPlus);
        BuilderExpr.dispatch(dispatchMap, "unaryminus", buildUnaryMinus);
        BuilderExpr.dispatch(dispatchMap, "*", buildMult);
        BuilderExpr.dispatch(dispatchMap, "multiply", buildMult);
        BuilderExpr.dispatch(dispatchMap, "/", buildDiv);
        BuilderExpr.dispatch(dispatchMap, "divide", buildDiv);
        BuilderExpr.dispatch(dispatchMap, "idiv", buildIDiv);
        BuilderExpr.dispatch(dispatchMap, "mod", buildMod);
        BuilderExpr.dispatch(dispatchMap, "str", buildStr);
        BuilderExpr.dispatch(dispatchMap, "strlang", buildStrLang);
        BuilderExpr.dispatch(dispatchMap, "strlangdir", buildStrLangDir);
        BuilderExpr.dispatch(dispatchMap, "strdt", buildStrDatatype);
        BuilderExpr.dispatch(dispatchMap, "year", buildYear);
        BuilderExpr.dispatch(dispatchMap, "month", buildMonth);
        BuilderExpr.dispatch(dispatchMap, "day", buildDay);
        BuilderExpr.dispatch(dispatchMap, "hours", buildHours);
        BuilderExpr.dispatch(dispatchMap, "minutes", buildMinutes);
        BuilderExpr.dispatch(dispatchMap, "seconds", buildSeconds);
        BuilderExpr.dispatch(dispatchMap, "timezone", buildTimezone);
        BuilderExpr.dispatch(dispatchMap, "tz", buildTZ);
        BuilderExpr.dispatch(dispatchMap, "adjust", buildAdjust);
        BuilderExpr.dispatch(dispatchMap, "rand", buildRand);
        BuilderExpr.dispatch(dispatchMap, "now", buildNow);
        BuilderExpr.dispatch(dispatchMap, "uuid", buildUUID);
        BuilderExpr.dispatch(dispatchMap, "struuid", buildStrUUID);
        BuilderExpr.dispatch(dispatchMap, "version", buildVersion);
        BuilderExpr.dispatch(dispatchMap, "md5", buildMD5);
        BuilderExpr.dispatch(dispatchMap, "sha1", buildSHA1);
        BuilderExpr.dispatch(dispatchMap, "sha224", buildSHA224);
        BuilderExpr.dispatch(dispatchMap, "sha256", buildSHA256);
        BuilderExpr.dispatch(dispatchMap, "sha384", buildSHA384);
        BuilderExpr.dispatch(dispatchMap, "sha512", buildSHA512);
        BuilderExpr.dispatch(dispatchMap, "strlen", buildStrlen);
        BuilderExpr.dispatch(dispatchMap, "substr", buildSubstr);
        BuilderExpr.dispatch(dispatchMap, "replace", buildStrReplace);
        BuilderExpr.dispatch(dispatchMap, "ucase", buildStrUppercase);
        BuilderExpr.dispatch(dispatchMap, "lcase", buildStrLowercase);
        BuilderExpr.dispatch(dispatchMap, "strends", buildStrEnds);
        BuilderExpr.dispatch(dispatchMap, "strstarts", buildStrStarts);
        BuilderExpr.dispatch(dispatchMap, "strbefore", buildStrBefore);
        BuilderExpr.dispatch(dispatchMap, "strafter", buildStrAfter);
        BuilderExpr.dispatch(dispatchMap, "contains", buildStrContains);
        BuilderExpr.dispatch(dispatchMap, "encode_for_uri", buildStrEncode);
        BuilderExpr.dispatch(dispatchMap, "abs", buildNumAbs);
        BuilderExpr.dispatch(dispatchMap, "round", buildNumRound);
        BuilderExpr.dispatch(dispatchMap, "ceil", buildNumCeiling);
        BuilderExpr.dispatch(dispatchMap, "floor", buildNumFloor);
        BuilderExpr.dispatch(dispatchMap, "lang", buildLang);
        BuilderExpr.dispatch(dispatchMap, "langdir", buildLangDir);
        BuilderExpr.dispatch(dispatchMap, "langMatches", buildLangMatches);
        BuilderExpr.dispatch(dispatchMap, "sameTerm", buildSameTerm);
        BuilderExpr.dispatch(dispatchMap, "sameValue", buildSameValue);
        BuilderExpr.dispatch(dispatchMap, "datatype", buildDatatype);
        BuilderExpr.dispatch(dispatchMap, "bound", buildBound);
        BuilderExpr.dispatch(dispatchMap, "coalesce", buildCoalesce);
        BuilderExpr.dispatch(dispatchMap, "concat", buildConcat);
        BuilderExpr.dispatch(dispatchMap, "if", buildIfExpr);
        BuilderExpr.dispatch(dispatchMap, "isIRI", buildIsIRI);
        BuilderExpr.dispatch(dispatchMap, "isURI", buildIsURI);
        BuilderExpr.dispatch(dispatchMap, "isBlank", buildIsBlank);
        BuilderExpr.dispatch(dispatchMap, "isLiteral", buildIsLiteral);
        BuilderExpr.dispatch(dispatchMap, "isNumeric", buildIsNumeric);
        BuilderExpr.dispatch(dispatchMap, "hasLang", buildIsLang);
        BuilderExpr.dispatch(dispatchMap, "hasLangDir", buildIsLangDir);
        BuilderExpr.dispatch(dispatchMap, "exists", buildExists);
        BuilderExpr.dispatch(dispatchMap, "notexists", buildNotExists);
        BuilderExpr.dispatch(dispatchMap, "bnode", buildBNode);
        BuilderExpr.dispatch(dispatchMap, "iri", buildIri);
        BuilderExpr.dispatch(dispatchMap, "uri", buildUri);
        BuilderExpr.dispatch(dispatchMap, "iri2", buildIri2);
        BuilderExpr.dispatch(dispatchMap, "uri2", buildUri2);
        BuilderExpr.dispatch(dispatchMap, "in", buildIn);
        BuilderExpr.dispatch(dispatchMap, "notin", buildNotIn);
        BuilderExpr.dispatch(dispatchMap, "subject", buildSubject);
        BuilderExpr.dispatch(dispatchMap, "predicate", buildPredicate);
        BuilderExpr.dispatch(dispatchMap, "object", buildObject);
        BuilderExpr.dispatch(dispatchMap, "triple", buildTripleFn);
        BuilderExpr.dispatch(dispatchMap, "isTriple", buildIsTriple);
        BuilderExpr.dispatch(dispatchMap, "call", buildCall);
        BuilderExpr.dispatch(dispatchMap, "count", buildCount);
        BuilderExpr.dispatch(dispatchMap, "sum", buildSum);
        BuilderExpr.dispatch(dispatchMap, "min", buildMin);
        BuilderExpr.dispatch(dispatchMap, "max", buildMax);
        BuilderExpr.dispatch(dispatchMap, "avg", buildAvg);
        BuilderExpr.dispatch(dispatchMap, "sample", buildSample);
        BuilderExpr.dispatch(dispatchMap, "group_concat", buildGroupConcat);
        BuilderExpr.dispatch(dispatchMap, "agg", buildCustomAggregate);
        return dispatchMap;
    }

    private static void dispatch(Map<String, Build> dispatchMap, String tag, Build build) {
        if (dispatchMap.containsKey(tag)) {
            throw new ARQInternalErrorException("Multiple dispatch entry for " + tag);
        }
        dispatchMap.put(tag, build);
    }

    static {
        buildRegex = list -> {
            BuilderLib.checkLength(3, 4, list, "Regex: wanted 2 or 3 arguments");
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            Expr pattern = BuilderExpr.buildExpr(list.get(2));
            Expr flags = null;
            if (list.size() != 3) {
                flags = BuilderExpr.buildExpr(list.get(3));
            }
            return new E_Regex(expr, pattern, flags);
        };
        buildPlus = list -> {
            BuilderLib.checkLength(2, 3, list, "+: wanted 1 or 2 arguments");
            if (list.size() == 2) {
                Expr ex = BuilderExpr.buildExpr(list.get(1));
                return new E_UnaryPlus(ex);
            }
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Add(left, right);
        };
        buildUnaryPlus = list -> {
            BuilderLib.checkLength(2, list, "unaryplus: wanted 1 argument");
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_UnaryPlus(ex);
        };
        buildMinus = list -> {
            BuilderLib.checkLength(2, 3, list, "-: wanted 1 or 2 arguments");
            if (list.size() == 2) {
                Expr ex = BuilderExpr.buildExpr(list.get(1));
                return new E_UnaryMinus(ex);
            }
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Subtract(left, right);
        };
        buildUnaryMinus = list -> {
            BuilderLib.checkLength(2, list, "unaryminus: wanted 1 argument");
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_UnaryMinus(ex);
        };
        buildEQ = list -> {
            BuilderLib.checkLength(3, list, "=: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Equals(left, right);
        };
        buildNE = list -> {
            BuilderLib.checkLength(3, list, "!=: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_NotEquals(left, right);
        };
        buildGT = list -> {
            BuilderLib.checkLength(3, list, ">: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_GreaterThan(left, right);
        };
        buildLT = list -> {
            BuilderLib.checkLength(3, list, "<: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LessThan(left, right);
        };
        buildLE = list -> {
            BuilderLib.checkLength(3, list, "<=: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LessThanOrEqual(left, right);
        };
        buildGE = list -> {
            BuilderLib.checkLength(3, list, ">=: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_GreaterThanOrEqual(left, right);
        };
        buildOr = list -> {
            BuilderLib.checkLength(3, list, "||: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LogicalOr(left, right);
        };
        buildAnd = list -> {
            BuilderLib.checkLength(3, list, "&&: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LogicalAnd(left, right);
        };
        buildNot = list -> {
            BuilderLib.checkLength(2, list, "!: wanted 1 argument: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_LogicalNot(ex);
        };
        buildEBV = list -> {
            BuilderLib.checkLength(2, list, "EBV: wanted 1 argument: got :" + BuilderExpr.numArgs(list));
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            return new E_EBV(expr);
        };
        buildMult = list -> {
            BuilderLib.checkLength(3, list, "*: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Multiply(left, right);
        };
        buildDiv = list -> {
            BuilderLib.checkLength(3, list, "/: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Divide(left, right);
        };
        buildIDiv = list -> {
            BuilderLib.checkLength(3, list, "idiv: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_OpNumericIntegerDivide(left, right);
        };
        buildMod = list -> {
            BuilderLib.checkLength(3, list, "mod: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_OpNumericMod(left, right);
        };
        buildStr = list -> {
            BuilderLib.checkLength(2, list, "str: wanted 1 argument: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Str(ex);
        };
        buildStrLang = list -> {
            BuilderLib.checkLength(3, list, "strlang: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrLang(ex1, ex2);
        };
        buildStrLangDir = list -> {
            BuilderLib.checkLength(4, list, "strlangdir: wanted 3 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            Expr ex3 = BuilderExpr.buildExpr(list.get(3));
            return new E_StrLangDir(ex1, ex2, ex3);
        };
        buildStrDatatype = list -> {
            BuilderLib.checkLength(3, list, "strlang: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrDatatype(ex1, ex2);
        };
        buildRand = list -> {
            BuilderLib.checkLength(1, list, "rand: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_Random();
        };
        buildYear = list -> {
            BuilderLib.checkLength(2, list, "year: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeYear(ex);
        };
        buildMonth = list -> {
            BuilderLib.checkLength(2, list, "month: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeMonth(ex);
        };
        buildDay = list -> {
            BuilderLib.checkLength(2, list, "day: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeDay(ex);
        };
        buildHours = list -> {
            BuilderLib.checkLength(2, list, "hours: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeHours(ex);
        };
        buildMinutes = list -> {
            BuilderLib.checkLength(2, list, "minutes: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeMinutes(ex);
        };
        buildSeconds = list -> {
            BuilderLib.checkLength(2, list, "seconds: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeSeconds(ex);
        };
        buildTimezone = list -> {
            BuilderLib.checkLength(2, list, "timezone: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeTimezone(ex);
        };
        buildTZ = list -> {
            BuilderLib.checkLength(2, list, "TZ: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeTZ(ex);
        };
        buildAdjust = list -> {
            BuilderLib.checkLength(2, 3, list, "adjust: wanted 1 or 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr expr1 = BuilderExpr.buildExpr(list.get(1));
            Expr expr2 = null;
            if (list.size() > 2) {
                expr2 = BuilderExpr.buildExpr(list.get(2));
            }
            return new E_AdjustToTimezone(expr1, expr2);
        };
        buildNow = list -> {
            BuilderLib.checkLength(1, list, "now: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_Now();
        };
        buildUUID = list -> {
            BuilderLib.checkLength(1, list, "uuid: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_UUID();
        };
        buildStrUUID = list -> {
            BuilderLib.checkLength(1, list, "struuid: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_StrUUID();
        };
        buildVersion = list -> {
            BuilderLib.checkLength(1, list, "version: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_Version();
        };
        buildMD5 = list -> {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_MD5(ex);
        };
        buildSHA1 = list -> {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA1(ex);
        };
        buildSHA224 = list -> {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA224(ex);
        };
        buildSHA256 = list -> {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA256(ex);
        };
        buildSHA384 = list -> {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA384(ex);
        };
        buildSHA512 = list -> {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA512(ex);
        };
        buildStrlen = list -> {
            BuilderLib.checkLength(2, list, "strlen: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_StrLength(ex);
        };
        buildSubstr = list -> {
            BuilderLib.checkLength(3, 4, list, "substr: wanted 2 or 3 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            Expr x = BuilderExpr.buildExpr(list.get(2));
            Expr y = null;
            if (list.size() == 4) {
                y = BuilderExpr.buildExpr(list.get(3));
            }
            return new E_StrSubstring(ex, x, y);
        };
        buildStrReplace = list -> {
            BuilderLib.checkLength(4, 5, list, "replace: wanted 3 or 4 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            Expr x = BuilderExpr.buildExpr(list.get(2));
            Expr y = BuilderExpr.buildExpr(list.get(3));
            Expr z = null;
            if (list.size() == 5) {
                z = BuilderExpr.buildExpr(list.get(4));
            }
            return new E_StrReplace(ex, x, y, z);
        };
        buildStrUppercase = list -> {
            BuilderLib.checkLength(2, list, "ucase: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_StrUpperCase(ex);
        };
        buildStrLowercase = list -> {
            BuilderLib.checkLength(2, list, "lcase: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_StrLowerCase(ex);
        };
        buildStrEnds = list -> {
            BuilderLib.checkLength(3, list, "strends: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrEndsWith(ex1, ex2);
        };
        buildStrStarts = list -> {
            BuilderLib.checkLength(3, list, "strstarts: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrStartsWith(ex1, ex2);
        };
        buildStrBefore = list -> {
            BuilderLib.checkLength(3, list, "strbefore: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrBefore(ex1, ex2);
        };
        buildStrAfter = list -> {
            BuilderLib.checkLength(3, list, "strafter: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrAfter(ex1, ex2);
        };
        buildStrContains = list -> {
            BuilderLib.checkLength(3, list, "contains: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrContains(ex1, ex2);
        };
        buildStrEncode = list -> {
            BuilderLib.checkLength(2, list, "encode: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_StrEncodeForURI(ex);
        };
        buildNumAbs = list -> {
            BuilderLib.checkLength(2, list, "abs: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_NumAbs(ex);
        };
        buildNumRound = list -> {
            BuilderLib.checkLength(2, list, "round: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_NumRound(ex);
        };
        buildNumCeiling = list -> {
            BuilderLib.checkLength(2, list, "ceiling: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_NumCeiling(ex);
        };
        buildNumFloor = list -> {
            BuilderLib.checkLength(2, list, "floor: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_NumFloor(ex);
        };
        buildLang = list -> {
            BuilderLib.checkLength(2, list, "lang: wanted 1 argument: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Lang(ex);
        };
        buildLangDir = list -> {
            BuilderLib.checkLength(2, list, "langdir: wanted 1 argument: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_LangDir(ex);
        };
        buildLangMatches = list -> {
            BuilderLib.checkLength(3, list, "langmatches: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LangMatches(left, right);
        };
        buildSameTerm = list -> {
            BuilderLib.checkLength(3, list, "sameterm: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_SameTerm(left, right);
        };
        buildSameValue = list -> {
            BuilderLib.checkLength(3, list, "samevalue: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_SameValue(left, right);
        };
        buildDatatype = list -> {
            BuilderLib.checkLength(2, list, "datatype: wanted 1 argument: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Datatype(ex);
        };
        buildBound = list -> {
            BuilderLib.checkLength(2, list, "bound: wanted 1 argument: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Bound(ex);
        };
        buildCoalesce = list -> {
            ExprList exprs = BuilderExpr.buildExprListUntagged(list, 1);
            return new E_Coalesce(exprs);
        };
        buildConcat = list -> {
            ExprList exprs = BuilderExpr.buildExprListUntagged(list, 1);
            return new E_StrConcat(exprs);
        };
        buildIfExpr = list -> {
            BuilderLib.checkLength(4, list, "IF: wanted 3 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            Expr ex3 = BuilderExpr.buildExpr(list.get(3));
            return new E_If(ex1, ex2, ex3);
        };
        buildIsIRI = list -> {
            BuilderLib.checkLength(2, list, "isIRI: wanted 1 argument: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsIRI(ex);
        };
        buildIsURI = list -> {
            BuilderLib.checkLength(2, list, "isURI: wanted 1 argument: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsURI(ex);
        };
        buildIsBlank = list -> {
            BuilderLib.checkLength(2, list, "isBlank: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsBlank(ex);
        };
        buildIsLiteral = list -> {
            BuilderLib.checkLength(2, list, "isLiteral: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsLiteral(ex);
        };
        buildIsNumeric = list -> {
            BuilderLib.checkLength(2, list, "isNumeric: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsNumeric(ex);
        };
        buildIsLang = list -> {
            BuilderLib.checkLength(2, list, "isLang: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_HasLang(ex);
        };
        buildIsLangDir = list -> {
            BuilderLib.checkLength(2, list, "isLangDir: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_HasLangDir(ex);
        };
        buildExists = list -> {
            BuilderLib.checkLength(2, list, "exists: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Op op = BuilderOp.build(list.get(1));
            return new E_Exists(op);
        };
        buildNotExists = list -> {
            BuilderLib.checkLength(2, list, "notexists: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Op op = BuilderOp.build(list.get(1));
            return new E_NotExists(op);
        };
        buildBNode = list -> {
            BuilderLib.checkLength(1, 2, list, "bnode: wanted 0 or 1 argument: got: " + BuilderExpr.numArgs(list));
            if (list.size() == 1) {
                return E_BNode.create();
            }
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            return E_BNode.create(expr);
        };
        buildIri = list -> {
            BuilderLib.checkLength(2, 3, list, "iri: wanted 1 or 2 arguments: got: " + BuilderExpr.numArgs(list));
            if (BuilderExpr.numArgs(list) == 1) {
                Expr expr = BuilderExpr.buildExpr(list.get(1));
                return new E_IRI(null, expr);
            }
            String str2 = BuilderExpr.asString(list.get(1));
            Expr expr2 = BuilderExpr.buildExpr(list.get(2));
            return new E_IRI(str2, expr2);
        };
        buildUri = list -> {
            BuilderLib.checkLength(2, 3, list, "uri: wanted 1 or 2 arguments: got: " + BuilderExpr.numArgs(list));
            if (BuilderExpr.numArgs(list) == 1) {
                Expr expr = BuilderExpr.buildExpr(list.get(1));
                return new E_URI(null, expr);
            }
            String str2 = BuilderExpr.asString(list.get(1));
            Expr expr2 = BuilderExpr.buildExpr(list.get(2));
            return new E_URI(str2, expr2);
        };
        buildIri2 = list -> {
            BuilderLib.checkLength(3, 4, list, "iri2: wanted 2 or 3 arguments: got: " + BuilderExpr.numArgs(list));
            if (BuilderExpr.numArgs(list) == 2) {
                Expr expr1 = BuilderExpr.buildExpr(list.get(1));
                Expr expr2 = BuilderExpr.buildExpr(list.get(2));
                return new E_IRI2(expr1, null, expr2);
            }
            String baseStr = BuilderExpr.asString(list.get(1));
            Expr expr1 = BuilderExpr.buildExpr(list.get(2));
            Expr expr2 = BuilderExpr.buildExpr(list.get(3));
            return new E_IRI2(expr1, baseStr, expr2);
        };
        buildUri2 = list -> {
            BuilderLib.checkLength(3, 4, list, "iri2: wanted 2 or 3 arguments: got: " + BuilderExpr.numArgs(list));
            if (BuilderExpr.numArgs(list) == 2) {
                Expr expr1 = BuilderExpr.buildExpr(list.get(1));
                Expr expr2 = BuilderExpr.buildExpr(list.get(2));
                return new E_URI2(expr1, expr2);
            }
            String baseStr = BuilderExpr.asString(list.get(1));
            Expr expr1 = BuilderExpr.buildExpr(list.get(2));
            Expr expr2 = BuilderExpr.buildExpr(list.get(3));
            return new E_URI2(expr1, baseStr, expr2);
        };
        buildIn = list -> {
            BuilderLib.checkLengthAtLeast(1, list, "in: wanted 1 or more arguments: got: " + BuilderExpr.numArgs(list));
            Item lhs = list.car();
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            ExprList eList = BuilderExpr.buildExprListUntagged(list, 2);
            return new E_OneOf(expr, eList);
        };
        buildNotIn = list -> {
            BuilderLib.checkLengthAtLeast(1, list, "notin: wanted 1 or more arguments: got: " + BuilderExpr.numArgs(list));
            Item lhs = list.car();
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            ExprList eList = BuilderExpr.buildExprListUntagged(list, 2);
            return new E_NotOneOf(expr, eList);
        };
        buildSubject = list -> {
            BuilderLib.checkLength(2, list, "subject: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            return new E_TripleSubject(expr);
        };
        buildPredicate = list -> {
            BuilderLib.checkLength(2, list, "predicate: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            return new E_TriplePredicate(expr);
        };
        buildObject = list -> {
            BuilderLib.checkLength(2, list, "object: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            return new E_TripleObject(expr);
        };
        buildTripleFn = list -> {
            BuilderLib.checkLength(4, list, "triple: wanted 3 arguments: got: " + BuilderExpr.numArgs(list));
            Expr expr1 = BuilderExpr.buildExpr(list.get(1));
            Expr expr2 = BuilderExpr.buildExpr(list.get(2));
            Expr expr3 = BuilderExpr.buildExpr(list.get(3));
            return new E_TripleFn(expr1, expr2, expr3);
        };
        buildIsTriple = list -> {
            BuilderLib.checkLength(2, list, "isTriple: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            return new E_IsTriple(expr);
        };
        buildCall = list -> {
            ExprList args = BuilderExpr.buildExprListUntagged(list, 1);
            return new E_Call(args);
        };
        buildCount = list -> {
            ItemList x = list.cdr();
            boolean distinct = BuilderExpr.startsWithDistinct(x);
            if (distinct) {
                x = x.cdr();
            }
            BuilderLib.checkLength(0, 1, x, "Broken syntax: " + list.shortString());
            Aggregator agg = null;
            if (x.size() == 0) {
                agg = AggregatorFactory.createCount(distinct);
            } else {
                Expr expr = BuilderExpr.buildExpr(x.get(0));
                agg = AggregatorFactory.createCountExpr(distinct, expr);
            }
            return new ExprAggregator(null, agg);
        };
        buildSum = BuilderExpr.aggCommonOne((distinct, expr) -> {
            Aggregator agg = AggregatorFactory.createSum(distinct, expr);
            return new ExprAggregator(null, agg);
        });
        buildMin = BuilderExpr.aggCommonOne((distinct, expr) -> {
            Aggregator agg = AggregatorFactory.createMin(distinct, expr);
            return new ExprAggregator(null, agg);
        });
        buildMax = BuilderExpr.aggCommonOne((distinct, expr) -> {
            Aggregator agg = AggregatorFactory.createMax(distinct, expr);
            return new ExprAggregator(null, agg);
        });
        buildAvg = BuilderExpr.aggCommonOne((distinct, expr) -> {
            Aggregator agg = AggregatorFactory.createAvg(distinct, expr);
            return new ExprAggregator(null, agg);
        });
        buildSample = BuilderExpr.aggCommonOne((distinct, expr) -> {
            Aggregator agg = AggregatorFactory.createSample(distinct, expr);
            return new ExprAggregator(null, agg);
        });
        buildGroupConcat = list -> {
            ItemList x = list.cdr();
            boolean distinct = BuilderExpr.startsWithDistinct(x);
            if (distinct) {
                x = x.cdr();
            }
            if (x.size() == 0) {
                BuilderLib.broken(list, "Broken syntax: " + list.shortString());
            }
            String separator = null;
            if (x.get(0).isTagged("separator")) {
                ItemList y = x.get(0).getList();
                BuilderLib.checkLength(2, y, "Broken syntax: " + String.valueOf(list));
                Node n = y.get(1).getNode();
                if (!NodeUtils.isSimpleString(n)) {
                    BuilderLib.broken(y, "Need string for separator: " + String.valueOf(y));
                }
                separator = n.getLiteralLexicalForm();
                x = x.cdr();
            }
            Expr expr = BuilderExpr.buildExpr(x.get(0));
            Aggregator agg = AggregatorFactory.createGroupConcat(distinct, expr, separator, null);
            return new ExprAggregator(null, agg);
        };
        buildCustomAggregate = list -> {
            boolean distinct;
            Item z;
            ItemList x = list.cdr();
            if (x.size() == 0) {
                BuilderLib.broken(list, "Missing IRI for aggregate");
            }
            if (!(z = x.car()).isNodeURI()) {
                BuilderLib.broken(list, "Not an IRI for aggregate: " + String.valueOf(z));
            }
            if (distinct = BuilderExpr.startsWithDistinct(x = x.cdr())) {
                x = x.cdr();
            }
            ExprList e2 = BuilderExpr.buildExprListUntagged(x, 0);
            Aggregator agg = AggregatorFactory.createCustom(z.getNode().getURI(), distinct, e2);
            return new ExprAggregator(null, agg);
        };
        buildAggNull = list -> {
            BuilderLib.checkLength(1, list, "Broken syntax: " + list.shortString());
            return new ExprAggregator(null, AggregatorFactory.createAggNull());
        };
        dispatch = BuilderExpr.createDispatchTable();
    }

    @FunctionalInterface
    private static interface Build {
        public Expr make(ItemList var1);
    }

    private static interface BuildAgg {
        public Expr aggExpr(boolean var1, Expr var2);
    }

    private static abstract class BuildAggCommon
    implements Build {
        private BuildAggCommon() {
        }

        @Override
        public Expr make(ItemList list) {
            ItemList x = list.cdr();
            boolean distinct = BuilderExpr.startsWithDistinct(x);
            if (distinct) {
                x = x.cdr();
            }
            BuilderLib.checkLength(1, x, "Broken syntax: " + list.shortString());
            Expr expr = BuilderExpr.buildExpr(x.get(0));
            return this.make(distinct, expr);
        }

        public abstract Expr make(boolean var1, Expr var2);
    }
}

