/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.solver;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.Map2;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.tdb1.store.NodeId;

public class BindingNodeId
extends Map2<Var, NodeId> {
    public static BindingNodeId root = new BindingNodeId(null, null, null){

        @Override
        public String toString() {
            return "<root>";
        }
    };
    private final Binding parentBinding;

    private BindingNodeId(Map<Var, NodeId> map1, Map2<Var, NodeId> map2, Binding parentBinding) {
        super(map1, map2);
        this.parentBinding = parentBinding;
    }

    public BindingNodeId(BindingNodeId other) {
        this(new HashMap<Var, NodeId>(), other, other != null ? other.getParentBinding() : null);
    }

    public BindingNodeId(Binding binding) {
        this(new HashMap<Var, NodeId>(), null, binding);
    }

    public BindingNodeId() {
        this(new HashMap<Var, NodeId>(), null, null);
    }

    public Binding getParentBinding() {
        return this.parentBinding;
    }

    @Override
    public void put(Var v, NodeId n) {
        if (v == null || n == null) {
            throw new IllegalArgumentException("(" + String.valueOf(v) + "," + String.valueOf(n) + ")");
        }
        super.put(v, n);
    }

    public void putAll(BindingNodeId other) {
        for (Var v : other) {
            if (v == null) {
                throw new IllegalArgumentException("Null key");
            }
            NodeId n = (NodeId)other.get(v);
            if (n == null) {
                throw new IllegalArgumentException("(" + String.valueOf(v) + "," + String.valueOf(n) + ")");
            }
            super.put(v, n);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Var v : this) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            NodeId x = (NodeId)this.get(v);
            if (NodeId.isDoesNotExist(x)) continue;
            sb.append(v);
            sb.append(" = ");
            sb.append(x);
        }
        if (this.getParentBinding() != null) {
            sb.append(" ->> ");
            sb.append(this.getParentBinding());
        }
        return sb.toString();
    }
}

