/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.transaction;

import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.Log;

public enum JournalEntryType {
    Block(1),
    Buffer(2),
    Object(3),
    Commit(4),
    Abort(5),
    Checkpoint(6);

    final int id;

    private JournalEntryType(int x) {
        this.id = x;
    }

    int getId() {
        return this.id;
    }

    public static JournalEntryType type(int x) {
        if (x == JournalEntryType.Block.id) {
            return Block;
        }
        if (x == JournalEntryType.Buffer.id) {
            return Buffer;
        }
        if (x == JournalEntryType.Object.id) {
            return Object;
        }
        if (x == JournalEntryType.Commit.id) {
            return Commit;
        }
        if (x == JournalEntryType.Abort.id) {
            return Abort;
        }
        if (x == JournalEntryType.Checkpoint.id) {
            return Checkpoint;
        }
        Log.error(JournalEntryType.class, "Unknown type: " + x);
        throw new InternalErrorException("Unknown type: " + x);
    }
}

