/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util.iterator;

import java.util.function.Consumer;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;

public abstract class LazyIterator<T>
extends NiceIterator<T> {
    private ExtendedIterator<T> it = null;

    @Override
    public boolean hasNext() {
        this.lazy();
        return this.it.hasNext();
    }

    @Override
    public T next() {
        this.lazy();
        return (T)this.it.next();
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.lazy();
        this.it.forEachRemaining(action);
    }

    @Override
    public void remove() {
        this.lazy();
        this.it.remove();
    }

    @Override
    public void close() {
        if (this.it != null) {
            this.it.close();
        }
    }

    private void lazy() {
        if (this.it == null) {
            this.it = this.create();
        }
    }

    public abstract ExtendedIterator<T> create();
}

