/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.search.uhighlight.TermVectorFilteredLeafReader;
import org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;

public class PostingsWithTermVectorsOffsetStrategy
extends FieldOffsetStrategy {
    public PostingsWithTermVectorsOffsetStrategy(UHComponents components) {
        super(components);
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader leafReader, int docId, String content) throws IOException {
        Terms docTerms = leafReader.termVectors().get(docId, this.getField());
        if (docTerms == null) {
            return OffsetsEnum.EMPTY;
        }
        leafReader = new TermVectorFilteredLeafReader(leafReader, docTerms, this.getField());
        return this.createOffsetsEnumFromReader(leafReader, docId);
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.POSTINGS_WITH_TERM_VECTORS;
    }
}

