/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MappedByteBufferIndexInputProvider;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SuppressForbidden;

public class MMapDirectory
extends FSDirectory {
    private static final Logger LOG = Logger.getLogger(MMapDirectory.class.getName());
    public static final BiPredicate<String, IOContext> ALL_FILES = (filename, context2) -> true;
    public static final BiPredicate<String, IOContext> NO_FILES = (filename, context2) -> false;
    public static final String SHARED_ARENA_MAX_PERMITS_SYSPROP = "org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits";
    public static final Function<String, Optional<String>> NO_GROUPING = filename -> Optional.empty();
    public static final Function<String, Optional<String>> GROUP_BY_SEGMENT = filename -> {
        if (!IndexFileNames.CODEC_FILE_PATTERN.matcher((CharSequence)filename).matches()) {
            return Optional.empty();
        }
        Object groupKey = IndexFileNames.parseSegmentName(filename).substring(1);
        try {
            if (IndexFileNames.parseGeneration(filename) > 0L) {
                groupKey = (String)groupKey + "-g";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Optional.of(groupKey);
    };
    public static final BiPredicate<String, IOContext> BASED_ON_LOAD_IO_CONTEXT = (filename, context2) -> context2.load;
    private BiPredicate<String, IOContext> preload = NO_FILES;
    public static final long DEFAULT_MAX_CHUNK_SIZE;
    public static final String ENABLE_UNMAP_HACK_SYSPROP = "org.apache.lucene.store.MMapDirectory.enableUnmapHack";
    public static final String ENABLE_MEMORY_SEGMENTS_SYSPROP = "org.apache.lucene.store.MMapDirectory.enableMemorySegments";
    final Object attachment = PROVIDER.attachment();
    private Function<String, Optional<String>> groupingFunction = GROUP_BY_SEGMENT;
    final int chunkSizePower;
    static final MMapIndexInputProvider<Object> PROVIDER;
    public static final boolean UNMAP_SUPPORTED;
    public static final String UNMAP_NOT_SUPPORTED_REASON;

    public MMapDirectory(Path path, LockFactory lockFactory) throws IOException {
        this(path, lockFactory, DEFAULT_MAX_CHUNK_SIZE);
    }

    public MMapDirectory(Path path) throws IOException {
        this(path, FSLockFactory.getDefault());
    }

    @Deprecated
    public MMapDirectory(Path path, int maxChunkSize) throws IOException {
        this(path, (long)maxChunkSize);
    }

    public MMapDirectory(Path path, long maxChunkSize) throws IOException {
        this(path, (LockFactory)FSLockFactory.getDefault(), maxChunkSize);
    }

    @Deprecated
    public MMapDirectory(Path path, LockFactory lockFactory, int maxChunkSize) throws IOException {
        this(path, lockFactory, (long)maxChunkSize);
    }

    public MMapDirectory(Path path, LockFactory lockFactory, long maxChunkSize) throws IOException {
        super(path, lockFactory);
        if (maxChunkSize <= 0L) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 63 - Long.numberOfLeadingZeros(maxChunkSize);
        assert (1L << this.chunkSizePower <= maxChunkSize);
        assert (1L << this.chunkSizePower > maxChunkSize / 2L);
    }

    @Deprecated(forRemoval=true)
    public void setUseUnmap(boolean useUnmapHack) {
        if (useUnmapHack != UNMAP_SUPPORTED) {
            throw new UnsupportedOperationException("It is no longer possible configure unmap hack for directory instances. Please use the global system property: org.apache.lucene.store.MMapDirectory.enableUnmapHack");
        }
    }

    @Deprecated
    public boolean getUseUnmap() {
        return UNMAP_SUPPORTED;
    }

    public void setPreload(BiPredicate<String, IOContext> preload) {
        this.preload = preload;
    }

    @Deprecated
    public void setPreload(boolean preload) {
        this.preload = preload ? ALL_FILES : NO_FILES;
    }

    @Deprecated
    public boolean getPreload() {
        return this.preload == ALL_FILES;
    }

    public void setGroupingFunction(Function<String, Optional<String>> groupingFunction) {
        this.groupingFunction = groupingFunction;
    }

    public final long getMaxChunkSize() {
        return 1L << this.chunkSizePower;
    }

    @Override
    public IndexInput openInput(String name, IOContext context2) throws IOException {
        this.ensureOpen();
        this.ensureCanRead(name);
        Path path = this.directory.resolve(name);
        return PROVIDER.openInput(path, context2, this.chunkSizePower, this.preload.test(name, context2), this.groupingFunction.apply(name), this.attachment);
    }

    @SuppressForbidden(reason="security manager")
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    private static boolean checkMemorySegmentsSysprop() {
        try {
            return Optional.ofNullable(System.getProperty(ENABLE_MEMORY_SEGMENTS_SYSPROP)).map(Boolean::valueOf).orElse(Boolean.TRUE);
        }
        catch (SecurityException ignored) {
            LOG.warning("Cannot read sysprop org.apache.lucene.store.MMapDirectory.enableMemorySegments, so MemorySegments will be enabled by default, if possible.");
            return true;
        }
    }

    private static int getSharedArenaMaxPermitsSysprop() {
        int ret = 1024;
        try {
            String str2 = System.getProperty(SHARED_ARENA_MAX_PERMITS_SYSPROP);
            if (str2 != null) {
                ret = Integer.parseInt(str2);
            }
        }
        catch (NumberFormatException | SecurityException ignored) {
            Logger.getLogger(MMapDirectory.class.getName()).warning("Cannot read sysprop org.apache.lucene.store.MMapDirectory.sharedArenaMaxPermits, so the default value will be used.");
        }
        return ret;
    }

    private static <A> MMapIndexInputProvider<A> lookupProvider() {
        if (!MMapDirectory.checkMemorySegmentsSysprop()) {
            return new MappedByteBufferIndexInputProvider();
        }
        int maxPermits = MMapDirectory.getSharedArenaMaxPermitsSysprop();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        int runtimeVersion = Runtime.version().feature();
        if (runtimeVersion >= 19) {
            try {
                Class<?> cls = lookup.findClass("org.apache.lucene.store.MemorySegmentIndexInputProvider");
                MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Integer.TYPE));
                try {
                    return constr.invoke(maxPermits);
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Throwable th) {
                    throw new AssertionError((Object)th);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e3) {
                throw new LinkageError("MemorySegmentIndexInputProvider is missing correctly typed constructor", e3);
            }
            catch (ClassNotFoundException cnfe) {
                throw new LinkageError("MemorySegmentIndexInputProvider is missing in Lucene JAR file", cnfe);
            }
        }
        return new MappedByteBufferIndexInputProvider();
    }

    public static boolean supportsMadvise() {
        return PROVIDER.supportsMadvise();
    }

    static {
        PROVIDER = MMapDirectory.doPrivileged(MMapDirectory::lookupProvider);
        DEFAULT_MAX_CHUNK_SIZE = PROVIDER.getDefaultMaxChunkSize();
        UNMAP_SUPPORTED = PROVIDER.isUnmapSupported();
        UNMAP_NOT_SUPPORTED_REASON = PROVIDER.getUnmapNotSupportedReason();
    }

    static interface MMapIndexInputProvider<A> {
        public IndexInput openInput(Path var1, IOContext var2, int var3, boolean var4, Optional<String> var5, A var6) throws IOException;

        public long getDefaultMaxChunkSize();

        public boolean isUnmapSupported();

        public String getUnmapNotSupportedReason();

        public boolean supportsMadvise();

        default public A attachment() {
            return null;
        }

        default public IOException convertMapFailedIOException(IOException ioe, String resourceDescription, long bufSize) {
            Throwable originalCause;
            String originalMessage;
            if (ioe.getCause() instanceof OutOfMemoryError) {
                originalMessage = "Map failed";
                originalCause = null;
            } else {
                originalMessage = ioe.getMessage();
                originalCause = ioe.getCause();
            }
            String moreInfo = !Constants.JRE_IS_64BIT ? "MMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.WINDOWS ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.LINUX ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
            IOException newIoe = new IOException(String.format(Locale.ENGLISH, "%s: %s [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of %d bytes. %sMore information: https://blog.thetaphi.de/2012/07/use-lucenes-mmapdirectory-on-64bit.html]", originalMessage, resourceDescription, bufSize, moreInfo), originalCause);
            newIoe.setStackTrace(ioe.getStackTrace());
            return newIoe;
        }
    }
}

