/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.ArrayList;
import java.util.List;
import javax.measure.UnitConverter;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.IdentityConverter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;

final class ConcatenatedConverter
extends AbstractConverter
implements LenientComparable {
    private static final long serialVersionUID = 6506147355157815065L;
    private final UnitConverter c1;
    private final UnitConverter c2;
    private transient ConcatenatedConverter inverse;

    ConcatenatedConverter(UnitConverter c1, UnitConverter c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    @Override
    public boolean isIdentity() {
        return this.c1.isIdentity() && this.c2.isIdentity();
    }

    @Override
    public boolean isLinear() {
        return this.c1.isLinear() && this.c2.isLinear();
    }

    @Override
    public synchronized UnitConverter inverse() {
        if (this.inverse == null) {
            this.inverse = new ConcatenatedConverter(this.c2.inverse(), this.c1.inverse());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public double convert(double value) {
        return this.c2.convert(this.c1.convert(value));
    }

    @Override
    public Number convert(Number value) {
        return this.c2.convert(this.c1.convert(value));
    }

    @Override
    public double derivative(double value) {
        return ConcatenatedConverter.derivative(this.c1, value) * ConcatenatedConverter.derivative(this.c2, this.c1.convert(value));
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        ArgumentChecks.ensureNonNull("converter", converter);
        if (this.equals(converter.inverse())) {
            return IdentityConverter.INSTANCE;
        }
        return this.c2.concatenate(this.c1.concatenate(converter));
    }

    @Override
    public List<UnitConverter> getConversionSteps() {
        ArrayList<UnitConverter> converters = new ArrayList<UnitConverter>();
        converters.addAll(this.c1.getConversionSteps());
        converters.addAll(this.c2.getConversionSteps());
        return converters;
    }

    public int hashCode() {
        return this.c1.hashCode() + 31 * this.c2.hashCode() ^ 0x68875F19;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ConcatenatedConverter) {
            ConcatenatedConverter o = (ConcatenatedConverter)other;
            return this.c1.equals(o.c1) && this.c2.equals(o.c2);
        }
        return false;
    }

    @Override
    public boolean equals(Object other, ComparisonMode mode) {
        if (other instanceof ConcatenatedConverter) {
            ConcatenatedConverter o = (ConcatenatedConverter)other;
            return Utilities.deepEquals(this.c1, o.c1, mode) && Utilities.deepEquals(this.c2, o.c2, mode);
        }
        return false;
    }
}

