/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.internal;

import java.sql.SQLException;
import java.text.Format;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.sis.metadata.internal.Identifiers;
import org.apache.sis.metadata.internal.ReferencingServices;
import org.apache.sis.metadata.internal.Resources;
import org.apache.sis.metadata.sql.util.Initializer;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.internal.MetadataServices;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.CodeList;

public final class ServicesForUtility
extends MetadataServices {
    @Override
    public boolean isUnmarshalling() {
        Context context2 = Context.current();
        return context2 != null && !Context.isFlagSet(context2, 1);
    }

    @Override
    public String getCodeTitle(CodeList<?> code, Locale locale) {
        return Types.getCodeTitle(code).toString(locale);
    }

    @Override
    public String getUnicodeIdentifier(Citation citation) {
        return Identifiers.getIdentifier(citation, true);
    }

    @Override
    public String getInformation(String key, Locale locale) {
        switch (key) {
            case "DataSource": {
                Object server = null;
                Object database = null;
                try {
                    DataSource ds = Initializer.getDataSource();
                    if (ds != null) {
                        Class<?> type = ds.getClass();
                        database = type.getMethod("getDatabaseName", null).invoke((Object)ds, (Object[])null);
                        server = type.getMethod("getServerName", null).invoke((Object)ds, (Object[])null);
                    }
                }
                catch (NoSuchMethodException e2) {
                    Logging.recoverableException(SystemListener.LOGGER, MetadataServices.class, "getInformation", e2);
                }
                catch (Exception e3) {
                    Object message = Exceptions.getLocalizedMessage(e3, locale);
                    if (message == null || ((String)message).indexOf(32) < 0) {
                        message = Classes.getShortClassName(e3) + ": " + (String)message;
                    }
                    return message;
                }
                if (database != null) {
                    if (server != null) {
                        database = "//" + server + "/" + database;
                    }
                    return database.toString();
                }
                return null;
            }
        }
        return ReferencingServices.getInstance().getInformation(key, locale);
    }

    @Override
    public Format createCoordinateFormat(Locale locale, TimeZone timezone2) {
        return ReferencingServices.getInstance().createCoordinateFormat(locale, timezone2);
    }

    @Override
    public DataSource getDataSource() throws SQLException {
        try {
            return Initializer.getDataSource();
        }
        catch (SQLException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new SQLException(Errors.format((short)6, "SpatialMetadata"), e3);
        }
    }

    @Override
    public void setDataSource(Supplier<DataSource> ds) {
        if (!Initializer.setDefault(ds)) {
            throw new IllegalStateException(Resources.format((short)6, "SpatialMetadata"));
        }
    }
}

