/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.provider.LambertConformal1SP;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.provider.Mercator2SP;
import org.apache.sis.referencing.operation.provider.ObliqueMercator;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.PlanarProjection;

@XmlTransient
public class Orthographic
extends MapProjection {
    private static final long serialVersionUID = -8669271590570783071L;
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    public static final ParameterDescriptor<Double> FALSE_EASTING;
    public static final ParameterDescriptor<Double> FALSE_NORTHING;
    private static final ParameterDescriptorGroup PARAMETERS;

    public Orthographic() {
        super(PlanarProjection.class, PARAMETERS);
    }

    @Override
    protected final NormalizedProjection createProjection(Parameters parameters) {
        return new org.apache.sis.referencing.operation.projection.Orthographic(this, parameters);
    }

    static {
        SCALE_FACTOR = Mercator2SP.SCALE_FACTOR;
        FALSE_EASTING = LambertConformal1SP.FALSE_EASTING;
        FALSE_NORTHING = LambertConformal1SP.FALSE_NORTHING;
        ParameterBuilder builder = Orthographic.builder();
        LATITUDE_OF_ORIGIN = Orthographic.createLatitude(Orthographic.renameAlias(builder, LambertConformal1SP.LATITUDE_OF_ORIGIN, Citations.ESRI, ObliqueMercator.LATITUDE_OF_CENTRE, Citations.GEOTIFF, ObliqueMercator.LATITUDE_OF_CENTRE), true);
        LONGITUDE_OF_ORIGIN = Orthographic.createLongitude(Orthographic.renameAlias(builder, LambertConformal1SP.LONGITUDE_OF_ORIGIN, Citations.ESRI, ObliqueMercator.LONGITUDE_OF_CENTRE, Citations.GEOTIFF, ObliqueMercator.LONGITUDE_OF_CENTRE));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9840")).addName("Orthographic")).addName(Citations.OGC, "Orthographic")).addName(Citations.ESRI, "Orthographic")).addName(Citations.NETCDF, "Orthographic")).addName(Citations.GEOTIFF, "CT_Orthographic")).addName(Citations.S57, "Orthographic")).addName(Citations.S57, "ORT")).addName(Citations.PROJ4, "ortho")).addIdentifier(Citations.GEOTIFF, "21")).addIdentifier(Citations.S57, "10")).createGroupForMapProjection(LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING);
    }
}

