/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.system;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public final class Reflect
implements Consumer<StackWalker.StackFrame> {
    private ClassLoader loader;
    private final Set<ClassLoader> parents = new HashSet<ClassLoader>();

    public static ClassLoader getContextClassLoader() throws SecurityException {
        Reflect walker = new Reflect();
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stream -> {
            stream.forEach(walker);
            return walker.loader;
        });
    }

    private Reflect() {
        this.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    private void setClassLoader(ClassLoader c) {
        this.loader = c;
        while (c != null) {
            this.parents.add(c);
            c = c.getParent();
        }
    }

    @Override
    public void accept(StackWalker.StackFrame frame) {
        ClassLoader c;
        if (frame.getClassName().startsWith("org.apache.sis.") && !this.parents.contains(c = frame.getDeclaringClass().getClassLoader())) {
            this.parents.clear();
            this.setClassLoader(c);
        }
    }
}

