/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.lan;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.xml.bind.Context;

public final class LocalisedCharacterString {
    private static final String PREFIX = "#locale-";
    Locale locale;
    @XmlValue
    public String text;

    public LocalisedCharacterString() {
    }

    LocalisedCharacterString(Locale locale, String text) {
        this.locale = locale;
        this.text = text;
    }

    @XmlAttribute(name="locale", required=true)
    public String getLocale() {
        if (this.locale == null) {
            return null;
        }
        Context context2 = Context.current();
        return PREFIX.concat(Context.converter(context2).toLanguageCode(context2, this.locale));
    }

    public void setLocale(String localeId) {
        if (localeId != null) {
            int start = localeId.indexOf(35) + 1;
            localeId = localeId.substring(Math.max(localeId.indexOf(45, start) + 1, start));
            Context context2 = Context.current();
            this.locale = Context.converter(context2).toLocale(context2, localeId);
        } else {
            this.locale = null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.text);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalisedCharacterString)) {
            return false;
        }
        LocalisedCharacterString that = (LocalisedCharacterString)object;
        return Objects.equals(this.locale, that.locale) && Objects.equals(this.text, that.text);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(80).append(this.getClass().getSimpleName()).append('[').append(this.getLocale());
        if (this.text != null) {
            buffer.append(", \u201c").append(this.text).append('\u201d');
        }
        return buffer.append(']').toString();
    }
}

