/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.transform.FacetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Facet
implements Serializable,
Cloneable,
StructuredPojo {
    private String documentAttributeKey;
    private List<Facet> facets;
    private Integer maxResults;

    public void setDocumentAttributeKey(String documentAttributeKey) {
        this.documentAttributeKey = documentAttributeKey;
    }

    public String getDocumentAttributeKey() {
        return this.documentAttributeKey;
    }

    public Facet withDocumentAttributeKey(String documentAttributeKey) {
        this.setDocumentAttributeKey(documentAttributeKey);
        return this;
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFacets(Collection<Facet> facets) {
        if (facets == null) {
            this.facets = null;
            return;
        }
        this.facets = new ArrayList<Facet>(facets);
    }

    public Facet withFacets(Facet ... facets) {
        if (this.facets == null) {
            this.setFacets(new ArrayList<Facet>(facets.length));
        }
        for (Facet ele : facets) {
            this.facets.add(ele);
        }
        return this;
    }

    public Facet withFacets(Collection<Facet> facets) {
        this.setFacets(facets);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public Facet withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentAttributeKey() != null) {
            sb.append("DocumentAttributeKey: ").append(this.getDocumentAttributeKey()).append(",");
        }
        if (this.getFacets() != null) {
            sb.append("Facets: ").append(this.getFacets()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Facet)) {
            return false;
        }
        Facet other = (Facet)obj;
        if (other.getDocumentAttributeKey() == null ^ this.getDocumentAttributeKey() == null) {
            return false;
        }
        if (other.getDocumentAttributeKey() != null && !other.getDocumentAttributeKey().equals(this.getDocumentAttributeKey())) {
            return false;
        }
        if (other.getFacets() == null ^ this.getFacets() == null) {
            return false;
        }
        if (other.getFacets() != null && !other.getFacets().equals(this.getFacets())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentAttributeKey() == null ? 0 : this.getDocumentAttributeKey().hashCode());
        hashCode = 31 * hashCode + (this.getFacets() == null ? 0 : this.getFacets().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public Facet clone() {
        try {
            return (Facet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FacetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

