/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kendra.model.DataSourceToIndexFieldMapping;
import com.amazonaws.services.kendra.model.DataSourceVpcConfiguration;
import com.amazonaws.services.kendra.model.FsxFileSystemType;
import com.amazonaws.services.kendra.model.transform.FsxConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FsxConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String fileSystemId;
    private String fileSystemType;
    private DataSourceVpcConfiguration vpcConfiguration;
    private String secretArn;
    private List<String> inclusionPatterns;
    private List<String> exclusionPatterns;
    private List<DataSourceToIndexFieldMapping> fieldMappings;

    public void setFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public FsxConfiguration withFileSystemId(String fileSystemId) {
        this.setFileSystemId(fileSystemId);
        return this;
    }

    public void setFileSystemType(String fileSystemType) {
        this.fileSystemType = fileSystemType;
    }

    public String getFileSystemType() {
        return this.fileSystemType;
    }

    public FsxConfiguration withFileSystemType(String fileSystemType) {
        this.setFileSystemType(fileSystemType);
        return this;
    }

    public FsxConfiguration withFileSystemType(FsxFileSystemType fileSystemType) {
        this.fileSystemType = fileSystemType.toString();
        return this;
    }

    public void setVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.vpcConfiguration = vpcConfiguration;
    }

    public DataSourceVpcConfiguration getVpcConfiguration() {
        return this.vpcConfiguration;
    }

    public FsxConfiguration withVpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
        this.setVpcConfiguration(vpcConfiguration);
        return this;
    }

    public void setSecretArn(String secretArn) {
        this.secretArn = secretArn;
    }

    public String getSecretArn() {
        return this.secretArn;
    }

    public FsxConfiguration withSecretArn(String secretArn) {
        this.setSecretArn(secretArn);
        return this;
    }

    public List<String> getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public void setInclusionPatterns(Collection<String> inclusionPatterns) {
        if (inclusionPatterns == null) {
            this.inclusionPatterns = null;
            return;
        }
        this.inclusionPatterns = new ArrayList<String>(inclusionPatterns);
    }

    public FsxConfiguration withInclusionPatterns(String ... inclusionPatterns) {
        if (this.inclusionPatterns == null) {
            this.setInclusionPatterns(new ArrayList<String>(inclusionPatterns.length));
        }
        for (String ele : inclusionPatterns) {
            this.inclusionPatterns.add(ele);
        }
        return this;
    }

    public FsxConfiguration withInclusionPatterns(Collection<String> inclusionPatterns) {
        this.setInclusionPatterns(inclusionPatterns);
        return this;
    }

    public List<String> getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public void setExclusionPatterns(Collection<String> exclusionPatterns) {
        if (exclusionPatterns == null) {
            this.exclusionPatterns = null;
            return;
        }
        this.exclusionPatterns = new ArrayList<String>(exclusionPatterns);
    }

    public FsxConfiguration withExclusionPatterns(String ... exclusionPatterns) {
        if (this.exclusionPatterns == null) {
            this.setExclusionPatterns(new ArrayList<String>(exclusionPatterns.length));
        }
        for (String ele : exclusionPatterns) {
            this.exclusionPatterns.add(ele);
        }
        return this;
    }

    public FsxConfiguration withExclusionPatterns(Collection<String> exclusionPatterns) {
        this.setExclusionPatterns(exclusionPatterns);
        return this;
    }

    public List<DataSourceToIndexFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        if (fieldMappings == null) {
            this.fieldMappings = null;
            return;
        }
        this.fieldMappings = new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings);
    }

    public FsxConfiguration withFieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
        if (this.fieldMappings == null) {
            this.setFieldMappings(new ArrayList<DataSourceToIndexFieldMapping>(fieldMappings.length));
        }
        for (DataSourceToIndexFieldMapping ele : fieldMappings) {
            this.fieldMappings.add(ele);
        }
        return this;
    }

    public FsxConfiguration withFieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
        this.setFieldMappings(fieldMappings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.getFileSystemId()).append(",");
        }
        if (this.getFileSystemType() != null) {
            sb.append("FileSystemType: ").append(this.getFileSystemType()).append(",");
        }
        if (this.getVpcConfiguration() != null) {
            sb.append("VpcConfiguration: ").append(this.getVpcConfiguration()).append(",");
        }
        if (this.getSecretArn() != null) {
            sb.append("SecretArn: ").append(this.getSecretArn()).append(",");
        }
        if (this.getInclusionPatterns() != null) {
            sb.append("InclusionPatterns: ").append(this.getInclusionPatterns()).append(",");
        }
        if (this.getExclusionPatterns() != null) {
            sb.append("ExclusionPatterns: ").append(this.getExclusionPatterns()).append(",");
        }
        if (this.getFieldMappings() != null) {
            sb.append("FieldMappings: ").append(this.getFieldMappings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FsxConfiguration)) {
            return false;
        }
        FsxConfiguration other = (FsxConfiguration)obj;
        if (other.getFileSystemId() == null ^ this.getFileSystemId() == null) {
            return false;
        }
        if (other.getFileSystemId() != null && !other.getFileSystemId().equals(this.getFileSystemId())) {
            return false;
        }
        if (other.getFileSystemType() == null ^ this.getFileSystemType() == null) {
            return false;
        }
        if (other.getFileSystemType() != null && !other.getFileSystemType().equals(this.getFileSystemType())) {
            return false;
        }
        if (other.getVpcConfiguration() == null ^ this.getVpcConfiguration() == null) {
            return false;
        }
        if (other.getVpcConfiguration() != null && !other.getVpcConfiguration().equals(this.getVpcConfiguration())) {
            return false;
        }
        if (other.getSecretArn() == null ^ this.getSecretArn() == null) {
            return false;
        }
        if (other.getSecretArn() != null && !other.getSecretArn().equals(this.getSecretArn())) {
            return false;
        }
        if (other.getInclusionPatterns() == null ^ this.getInclusionPatterns() == null) {
            return false;
        }
        if (other.getInclusionPatterns() != null && !other.getInclusionPatterns().equals(this.getInclusionPatterns())) {
            return false;
        }
        if (other.getExclusionPatterns() == null ^ this.getExclusionPatterns() == null) {
            return false;
        }
        if (other.getExclusionPatterns() != null && !other.getExclusionPatterns().equals(this.getExclusionPatterns())) {
            return false;
        }
        if (other.getFieldMappings() == null ^ this.getFieldMappings() == null) {
            return false;
        }
        return other.getFieldMappings() == null || other.getFieldMappings().equals(this.getFieldMappings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileSystemId() == null ? 0 : this.getFileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystemType() == null ? 0 : this.getFileSystemType().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfiguration() == null ? 0 : this.getVpcConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSecretArn() == null ? 0 : this.getSecretArn().hashCode());
        hashCode = 31 * hashCode + (this.getInclusionPatterns() == null ? 0 : this.getInclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getExclusionPatterns() == null ? 0 : this.getExclusionPatterns().hashCode());
        hashCode = 31 * hashCode + (this.getFieldMappings() == null ? 0 : this.getFieldMappings().hashCode());
        return hashCode;
    }

    public FsxConfiguration clone() {
        try {
            return (FsxConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FsxConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

